/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.listeners;

import com.google.common.collect.Sets;
import io.github.nucleuspowered.nucleus.modules.world.config.WorldConfig;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.world.World;

public class EnforceGamemodeListener
implements ListenerBase.Conditional {
    private final PluginContainer pluginContainer;

    @Inject
    public EnforceGamemodeListener(INucleusServiceCollection serviceCollection) {
        this.pluginContainer = serviceCollection.pluginContainer();
    }

    @Listener(order=Order.POST)
    public void onPlayerLogin(ClientConnectionEvent.Join event, @Getter(value="getTargetEntity") Player player) {
        Task.builder().execute(() -> this.enforce(player, player.getWorld())).submit((Object)this.pluginContainer);
    }

    @Listener(order=Order.POST)
    public void onPlayerTeleport(MoveEntityEvent.Teleport event, @Getter(value="getTargetEntity") Player player, @Getter(value="getFromTransform") Transform<World> from, @Getter(value="getToTransform") Transform<World> to) {
        if (!((World)from.getExtent()).getUniqueId().equals(((World)to.getExtent()).getUniqueId())) {
            this.enforce(player, (World)to.getExtent());
        }
    }

    private void enforce(Player player, World world) {
        if (world.getProperties().getGameMode() == GameModes.NOT_SET) {
            return;
        }
        HashSet contextSet = Sets.newHashSet((Iterable)player.getActiveContexts());
        contextSet.removeIf(x -> x.getKey().equals("world"));
        contextSet.add(new Context("world", world.getName()));
        if (!player.hasPermission((Set)contextSet, "nucleus.world.force-gamemode.override")) {
            player.offer(Keys.GAME_MODE, (Object)world.getProperties().getGameMode());
        }
    }

    @Override
    public boolean shouldEnable(INucleusServiceCollection serviceCollection) {
        return serviceCollection.moduleDataProvider().getModuleConfig(WorldConfig.class).isEnforceGamemodeOnWorldChange();
    }
}

