/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdscheduler.schedule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mcsimonflash.sponge.cmdscheduler.schedule.Modifiers;
import com.mcsimonflash.sponge.cmdscheduler.schedule.Schedule;
import com.mcsimonflash.sponge.cmdscheduler.schedule.Units;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.util.ResettableBuilder;

public class CronSchedule
implements Schedule {
    private final ImmutableMap<Units, ImmutableSortedSet<Integer>> sets;

    private CronSchedule(ImmutableMap<Units, ImmutableSortedSet<Integer>> sets) {
        this.sets = sets;
    }

    @Override
    public long getDelay(Calendar calendar) {
        int[] times = new int[6];
        boolean wrap = false;
        try {
            for (Units unit : Units.values()) {
                wrap = this.calculateNextTime(times, unit, wrap ? 0 : calendar.get(unit.constant) + (unit == Units.MONTHS ? 1 : 0)) || wrap;
            }
        }
        catch (IllegalArgumentException e) {
            return -1L;
        }
        Calendar matched = (Calendar)calendar.clone();
        for (Units unit : Units.values()) {
            matched.set(unit.constant, times[unit.ordinal()] - (unit == Units.MONTHS ? 1 : 0));
        }
        return matched.getTimeInMillis() - calendar.getTimeInMillis();
    }

    @Override
    public long getInterval() {
        return -1L;
    }

    private boolean calculateNextTime(int[] times, Units unit, int from) {
        times[unit.ordinal()] = (Integer)Optional.ofNullable(((ImmutableSortedSet)this.sets.getOrDefault((Object)unit, unit.values)).ceiling((Object)from)).orElse(-1);
        if (times[unit.ordinal()] == -1 || unit == Units.DAYS && !YearMonth.now().withMonth(times[0]).isValidDay(times[1])) {
            Preconditions.checkArgument((unit != Units.MONTHS ? 1 : 0) != 0, (Object)"Year wrap.");
            this.calculateNextTime(times, Units.values()[unit.ordinal() - 1], times[unit.ordinal() - 1] + 1);
            this.calculateNextTime(times, unit, unit.lower);
            return true;
        }
        return times[unit.ordinal()] != from;
    }

    public boolean hasUnit(Units unit) {
        return this.sets.containsKey((Object)unit);
    }

    public ImmutableSet<Integer> getUnit(Units unit) {
        return (ImmutableSet)this.sets.getOrDefault((Object)unit, unit.values);
    }

    public String toString() {
        ArrayList sets = Lists.newArrayList();
        for (Units unit : Units.values()) {
            if (!this.hasUnit(unit)) continue;
            sets.add(unit.name().toLowerCase() + "=" + this.getUnit(unit));
        }
        return "CronSchedule{" + String.join((CharSequence)", ", sets) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements ResettableBuilder<CronSchedule, Builder> {
        private final EnumMap<Units, ImmutableSortedSet<Integer>> sets = Maps.newEnumMap(Units.class);

        public Builder from(CronSchedule value) {
            for (Units unit : Units.values()) {
                if (!value.hasUnit(unit)) continue;
                this.setUnit(unit, (Set<Integer>)value.getUnit(unit));
            }
            return this;
        }

        public Builder reset() {
            this.sets.clear();
            return this;
        }

        public Builder setUnit(Units unit, Set<Integer> set) throws IllegalArgumentException {
            Preconditions.checkArgument((!set.isEmpty() ? 1 : 0) != 0, (Object)"Set must be defined.");
            Preconditions.checkArgument((boolean)unit.values.containsAll(set), (Object)("Set contains illegal values. | Values:[" + Sets.difference(unit.values, set) + "]"));
            if (!unit.values.equals(set)) {
                this.sets.put(unit, (ImmutableSortedSet<Integer>)ImmutableSortedSet.copyOf(set));
            }
            return this;
        }

        public Builder setUnit(Units unit, Integer ... values) throws IllegalArgumentException {
            return this.setUnit(unit, Sets.newHashSet((Object[])values));
        }

        public Builder setUnit(Units unit, String modifier) throws IllegalArgumentException {
            return this.setUnit(unit, Modifiers.buildSet(unit, modifier));
        }

        public Builder setMin(Units ... units) throws IllegalArgumentException {
            for (Units unit : units) {
                this.setUnit(unit, Sets.newHashSet((Object[])new Integer[]{unit.lower}));
            }
            return this;
        }

        public Builder schedule(String schedule) throws IllegalArgumentException {
            Modifiers.buildSchedule(schedule).forEach(this::setUnit);
            return this;
        }

        public CronSchedule build() throws IllegalArgumentException {
            return new CronSchedule(Maps.immutableEnumMap(this.sets));
        }
    }
}

