/*
 * Decompiled with CFR 0.152.
 */
package openmods.access;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import openmods.Log;
import openmods.access.ApiProviderRegistry;
import openmods.utils.CachedFactory;
import org.objectweb.asm.Type;

public class ApiFactory {
    public static final ApiFactory instance = new ApiFactory();
    private final Set<Class<? extends Annotation>> apis = Sets.newHashSet();

    private static <A> void fillTargetField(ClassInfoCache clsCache, ApiProviderRegistry<A> registry, ASMDataTable.ASMData data, Class<A> interfaceMarker) {
        String targetClassName = data.getClassName();
        String targetObjectName = data.getObjectName();
        ClassInfo targetCls = (ClassInfo)clsCache.getOrCreate(targetClassName);
        Setter setter = targetCls.get(targetObjectName);
        Preconditions.checkArgument((setter != null ? 1 : 0) != 0, (String)"Entry '%s' in class '%s' is not valid target for API annotation", (Object)targetObjectName, (Object)targetClassName);
        Class<?> acceptedType = setter.getType();
        Preconditions.checkState((boolean)interfaceMarker.isAssignableFrom(acceptedType), (String)"Failed to set API object on %s:%s - invalid type, expected %s", (Object)targetClassName, (Object)targetObjectName, interfaceMarker);
        Class<A> castAcceptedType = acceptedType.asSubclass(interfaceMarker);
        A api = registry.getApi(castAcceptedType);
        if (api != null) {
            try {
                setter.set(api);
            }
            catch (Throwable t) {
                throw new RuntimeException(String.format("Failed to set entry '%s' in class '%s'", targetObjectName, targetClassName), t);
            }
            Log.trace("Injecting instance of %s from mod %s to field %s:%s from file %s", castAcceptedType, Loader.instance().activeModContainer().getModId(), targetClassName, targetObjectName, data.getCandidate().getModContainer());
        } else {
            Log.info("Can't set API field %s:%s - no API for type %s", targetClassName, targetObjectName, castAcceptedType);
        }
    }

    private static <A> void fillTargetFields(ApiProviderRegistry<A> registry, ASMDataTable table, Class<? extends Annotation> fieldMarker, Class<A> interfaceMarker) {
        ClassInfoCache clsCache = new ClassInfoCache();
        Set targets = table.getAll(fieldMarker.getName());
        for (ASMDataTable.ASMData data : targets) {
            ApiFactory.fillTargetField(clsCache, registry, data, interfaceMarker);
        }
    }

    public <A> ApiProviderRegistry<A> createApi(Class<? extends Annotation> fieldMarker, Class<A> interfaceMarker, ASMDataTable table, ApiProviderSetup<A> registrySetup) {
        Preconditions.checkState((boolean)this.apis.add(fieldMarker), (String)"Duplicate API registration on %s", fieldMarker);
        ApiProviderRegistry<A> registry = new ApiProviderRegistry<A>(interfaceMarker);
        registrySetup.setup(registry);
        registry.freeze();
        ApiFactory.fillTargetFields(registry, table, fieldMarker, interfaceMarker);
        return registry;
    }

    public <A> void createApi(Class<? extends Annotation> fieldMarker, Class<A> interfaceMarker, ASMDataTable table, ApiProviderRegistry<A> registry) {
        Preconditions.checkState((boolean)this.apis.add(fieldMarker), (String)"Duplicate API registration on %s", fieldMarker);
        Preconditions.checkState((boolean)registry.isFrozen(), (Object)"Registry must be frozen");
        ApiFactory.fillTargetFields(registry, table, fieldMarker, interfaceMarker);
    }

    public static interface ApiProviderSetup<A> {
        public void setup(ApiProviderRegistry<A> var1);
    }

    private static class ClassInfoCache
    extends CachedFactory<String, ClassInfo> {
        private ClassInfoCache() {
        }

        @Override
        protected ClassInfo create(String className) {
            try {
                Class<?> cls = Class.forName(className, true, this.getClass().getClassLoader());
                return new ClassInfo(cls);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ClassInfo {
        private Map<String, Setter> setters = Maps.newHashMap();

        public ClassInfo(Class<?> cls) {
            int modifiers;
            for (final Field field : cls.getDeclaredFields()) {
                modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers)) continue;
                final Class<?> type = field.getType();
                field.setAccessible(true);
                if (Modifier.isFinal(modifiers)) {
                    this.setters.put(field.getName(), new Setter(){

                        @Override
                        public void set(Object value) throws Exception {
                            EnumHelper.setFailsafeFieldValue((Field)field, null, (Object)value);
                        }

                        @Override
                        public Class<?> getType() {
                            return type;
                        }
                    });
                    continue;
                }
                this.setters.put(field.getName(), new Setter(){

                    @Override
                    public void set(Object value) throws Exception {
                        field.set(null, value);
                    }

                    @Override
                    public Class<?> getType() {
                        return type;
                    }
                });
            }
            for (AccessibleObject accessibleObject : cls.getDeclaredMethods()) {
                Class<?>[] params;
                modifiers = ((Method)accessibleObject).getModifiers();
                if (!Modifier.isStatic(modifiers) || ((Method)accessibleObject).getReturnType() != Void.TYPE || (params = ((Method)accessibleObject).getParameterTypes()).length != 1) continue;
                Class<?> param = params[0];
                ((Method)accessibleObject).setAccessible(true);
                String id = ((Method)accessibleObject).getName() + Type.getMethodDescriptor((Method)accessibleObject);
                this.setters.put(id, new Setter((Method)accessibleObject, param){
                    final /* synthetic */ Method val$m;
                    final /* synthetic */ Class val$param;
                    {
                        this.val$m = method;
                        this.val$param = clazz;
                    }

                    @Override
                    public void set(Object value) throws Exception {
                        this.val$m.invoke(null, value);
                    }

                    @Override
                    public Class<?> getType() {
                        return this.val$param;
                    }
                });
            }
        }

        public Setter get(String name) {
            return this.setters.get(name);
        }
    }

    private static interface Setter {
        public Class<?> getType();

        public void set(Object var1) throws Exception;
    }
}

