/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.tile.MachineType;
import ic2.api.recipe.IRecipeInput;
import ic2.core.block.base.tile.TileEntityBasicElectricMachine;
import ic2.core.inventory.gui.custom.MachineGui;
import ic2.core.item.recipe.AdvRecipeBase;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import ic2.core.item.recipe.entry.RecipeInputOreDict;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.misc.StackUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityMacerator
extends TileEntityBasicElectricMachine {
    public static final Set<String> oreBlacklist = new HashSet<String>(Arrays.asList("oreCoal", "oreIron", "oreGold", "oreSilver", "oreCopper", "oreTin", "oreRedstone", "oreUranium"));
    public static final Set<String> ingotBlackList = new HashSet<String>(Arrays.asList("ingotIron", "ingotGold", "ingotSilver", "ingotCopper", "ingotTin", "ingotBronze"));

    public TileEntityMacerator() {
        super(3, 2, 400, 32);
    }

    @Override
    public IMachineRecipeList getRecipeList() {
        return ClassicRecipes.macerator;
    }

    @Override
    public MachineType getType() {
        return MachineType.macerator;
    }

    @Override
    public ResourceLocation getGuiTexture() {
        return Ic2Resources.macerator;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.macerator;
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return MachineGui.MaceratorGui.class;
    }

    @Override
    public IMachineRecipeList.RecipeEntry getOutputFor(ItemStack input) {
        return ClassicRecipes.macerator.getRecipeInAndOutput(input, false);
    }

    @Override
    public ResourceLocation getStartSoundFile() {
        return Ic2Sounds.maceratorOp;
    }

    @Override
    public ResourceLocation getInterruptSoundFile() {
        return Ic2Sounds.interruptingSound;
    }

    @Override
    public double getWrenchDropRate() {
        return 0.85f;
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        if (par1 == null) {
            return false;
        }
        if (ClassicRecipes.macerator.getRecipeInAndOutput(par1, true) != null) {
            return super.isValidInput(par1);
        }
        return false;
    }

    public static void postInit() {
        for (String id : OreDictionary.getOreNames()) {
            NonNullList list;
            String dust;
            if (id.startsWith("ore")) {
                if (oreBlacklist.contains(id) || !OreDictionary.doesOreNameExist((String)(dust = "dust" + id.substring(3))) || (list = OreDictionary.getOres((String)dust, (boolean)false)).isEmpty()) continue;
                TileEntityMacerator.addRecipe(id, 1, StackUtil.copyWithSize((ItemStack)list.get(0), 2));
                continue;
            }
            if (!id.startsWith("ingot") || ingotBlackList.contains(id) || !OreDictionary.doesOreNameExist((String)(dust = "dust" + id.substring(5))) || (list = OreDictionary.getOres((String)dust, (boolean)false)).isEmpty()) continue;
            TileEntityMacerator.addRecipe(id, 1, ((ItemStack)list.get(0)).func_77946_l());
        }
    }

    public static void init() {
        TileEntityMacerator.addRecipe(new ItemStack(Items.field_151044_h), Ic2Items.coalDust.func_77946_l(), 0.1f);
        TileEntityMacerator.addRecipe(new ItemStack(Items.field_151044_h, 1, 1), Ic2Items.charcoalDust.func_77946_l(), 0.05f);
        TileEntityMacerator.addRecipe("oreCoal", 1, StackUtil.copyWithSize(Ic2Items.coalDust, 2), 0.5f);
        TileEntityMacerator.addRecipe(new ItemStack(Blocks.field_150402_ci), StackUtil.copyWithSize(Ic2Items.coalDust, 9), 1.0f);
        TileEntityMacerator.addRecipe("oreIron", 1, StackUtil.copyWithSize(Ic2Items.ironDust, 2), 0.7f);
        TileEntityMacerator.addRecipe("ingotIron", 1, Ic2Items.ironDust.func_77946_l(), 0.1f);
        TileEntityMacerator.addRecipe(Ic2Items.refinedIronIngot.func_77946_l(), Ic2Items.ironDust.func_77946_l());
        TileEntityMacerator.addRecipe("oreGold", 1, StackUtil.copyWithSize(Ic2Items.goldDust, 2), 1.0f);
        TileEntityMacerator.addRecipe("ingotGold", 1, Ic2Items.goldDust.func_77946_l(), 0.1f);
        TileEntityMacerator.addRecipe(new ItemStack(Blocks.field_150450_ax), new ItemStack(Items.field_151137_ax, 16), 0.7f);
        TileEntityMacerator.addRecipe("oreSilver", 1, StackUtil.copyWithSize(Ic2Items.silverDust, 2), 0.8f);
        TileEntityMacerator.addRecipe("ingotSilver", 1, Ic2Items.silverDust.func_77946_l(), 0.1f);
        TileEntityMacerator.addRecipe("ingotCopper", 1, Ic2Items.copperDust.func_77946_l(), 0.1f);
        TileEntityMacerator.addRecipe("ingotBronze", 1, Ic2Items.bronzeDust.func_77946_l());
        TileEntityMacerator.addRecipe("oreCopper", 1, StackUtil.copyWithSize(Ic2Items.copperDust, 2), 0.3f);
        TileEntityMacerator.addRecipe("ingotTin", 1, Ic2Items.tinDust.func_77946_l(), 0.1f);
        TileEntityMacerator.addRecipe("oreTin", 1, StackUtil.copyWithSize(Ic2Items.tinDust, 2), 0.4f);
        TileEntityMacerator.addRecipe(new ItemStack(Blocks.field_150424_aL), Ic2Items.netherrackDust.func_77946_l());
        TileEntityMacerator.addRecipe("oreQuartz", 1, new ItemStack(Items.field_151128_bU, 2));
        TileEntityMacerator.addRecipe("oreUranium", 1, StackUtil.copyWithSize(Ic2Items.uraniumDrop, 2), 1.0f);
        TileEntityMacerator.addRecipe(Ic2Items.charcoalBlock.func_77946_l(), StackUtil.copyWithSize(Ic2Items.charcoalDust, 9), 0.5f);
        TileEntityMacerator.addRecipe(new ItemStack(Items.field_151072_bj), new ItemStack(Items.field_151065_br, 5), 0.3f);
        TileEntityMacerator.addRecipe(new ItemStack(Items.field_151070_bp), StackUtil.copyWithSize(Ic2Items.grinPowder, 2), 0.4f);
        TileEntityMacerator.addRecipe(new ItemStack(Items.field_151115_aP, 1, 3), StackUtil.copyWithSize(Ic2Items.grinPowder, 3), 0.4f);
        TileEntityMacerator.addRecipe(new ItemStack(Items.field_151170_bI), StackUtil.copyWithSize(Ic2Items.grinPowder, 2), 0.4f);
        TileEntityMacerator.addRecipe(new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE), new ItemStack(Items.field_151007_F, 3), 0.1f);
        TileEntityMacerator.addRecipe(new ItemStack(Blocks.field_150348_b), new ItemStack(Blocks.field_150351_n), 0.1f);
        TileEntityMacerator.addRecipe(new ItemStack(Blocks.field_150347_e), new ItemStack((Block)Blocks.field_150354_m), 0.1f);
        TileEntityMacerator.addRecipe(new ItemStack(Blocks.field_150322_A), new ItemStack((Block)Blocks.field_150354_m), 0.1f);
        TileEntityMacerator.addRecipe(new ItemStack(Blocks.field_180395_cM), new ItemStack((Block)Blocks.field_150354_m, 1, 1), 0.1f);
        TileEntityMacerator.addRecipe(new ItemStack(Blocks.field_150432_aD), new ItemStack(Items.field_151126_ay), 0.1f);
        TileEntityMacerator.addRecipe(new ItemStack(Blocks.field_150435_aG), StackUtil.copyWithSize(Ic2Items.clayDust, 2), 0.3f);
        TileEntityMacerator.addRecipe(new ItemStack(Blocks.field_150426_aN), new ItemStack(Items.field_151114_aO, 4), 0.15f);
        TileEntityMacerator.addRecipe(new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151100_aR, 5, 15), 0.2f);
        TileEntityMacerator.addRecipe(Ic2Items.plantBall.func_77946_l(), new ItemStack(Blocks.field_150346_d, 8), 0.1f);
        TileEntityMacerator.addRecipe(Ic2Items.coffeeBeans.func_77946_l(), StackUtil.copyWithSize(Ic2Items.coffeePowder, 3), 0.4f);
        TileEntityMacerator.addRecipe(new ItemStack(Blocks.field_150343_Z), Ic2Items.obsidianDust.func_77946_l(), 0.1f);
        TileEntityMacerator.addRecipe("cropWheat", 1, Ic2Items.flour.func_77946_l(), 0.3f);
        TileEntityMacerator.addRecipe(Ic2Items.bioBall.func_77946_l(), StackUtil.copyWithSize(Ic2Items.bioRawFiber, 2), 0.1f);
    }

    public static void addRecipe(ItemStack input, ItemStack output) {
        TileEntityMacerator.addRecipe(new RecipeInputItemStack(input), output);
    }

    public static void addRecipe(ItemStack input, int stacksize, ItemStack output) {
        TileEntityMacerator.addRecipe(new RecipeInputItemStack(input, stacksize), output);
    }

    public static void addRecipe(String input, int stacksize, ItemStack output) {
        TileEntityMacerator.addRecipe(new RecipeInputOreDict(input, stacksize), output);
    }

    public static void addRecipe(ItemStack input, ItemStack output, float exp) {
        TileEntityMacerator.addRecipe(new RecipeInputItemStack(input), output, exp);
    }

    public static void addRecipe(ItemStack input, int stacksize, ItemStack output, float exp) {
        TileEntityMacerator.addRecipe(new RecipeInputItemStack(input, stacksize), output, exp);
    }

    public static void addRecipe(String input, int stacksize, ItemStack output, float exp) {
        TileEntityMacerator.addRecipe(new RecipeInputOreDict(input, stacksize), output, exp);
    }

    public static void addRecipe(IRecipeInput input, ItemStack output) {
        TileEntityMacerator.addRecipe(input, output, 0.0f);
    }

    public static void addRecipe(IRecipeInput input, ItemStack output, float exp) {
        ClassicRecipes.macerator.addRecipe(input, output, exp, AdvRecipeBase.getRecipeID(Arrays.asList(input), Arrays.asList(output), TileEntityMacerator.makeString(output)));
    }

    private static String makeString(ItemStack stack) {
        return stack.func_77977_a();
    }
}

