/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low.logic.miner;

import ic2.core.block.machine.low.TileEntityMiner;
import ic2.core.block.machine.low.logic.miner.IMiningTarget;
import ic2.core.util.misc.FluidHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidMiningTarget
implements IMiningTarget {
    IBlockState state;
    BlockPos pos;
    List<ItemStack> drops = new ArrayList<ItemStack>();
    boolean buildCache = false;
    FluidStack cache;

    public FluidMiningTarget() {
    }

    public FluidMiningTarget(IBlockState state, BlockPos pos) {
        this.state = state;
        this.pos = pos;
    }

    @Override
    public boolean validateTarget(TileEntityMiner miner) {
        return miner.func_145831_w().func_180495_p(this.pos) == this.state;
    }

    @Override
    public BlockPos getTargetPos() {
        return this.pos;
    }

    @Override
    public IBlockState getMemoryState() {
        return this.state;
    }

    @Override
    public boolean canMine(TileEntityMiner miner) {
        try {
            if (!miner.hasPumps()) {
                return miner.canMineEvent(this.pos, this.state);
            }
            if (miner.canMine(this.pos, this.state)) {
                return miner.canPumpFluid(this.getCache(miner.func_145831_w())) != EnumActionResult.FAIL;
            }
        }
        catch (Exception e) {
            this.state = miner.func_145831_w().func_180495_p(this.pos);
            return this.canMine(miner);
        }
        return false;
    }

    @Override
    public boolean canContinue(TileEntityMiner miner) {
        if (!miner.hasPumps()) {
            return true;
        }
        return miner.canPumpFluid(this.getCache(miner.func_145831_w())) == EnumActionResult.SUCCESS;
    }

    @Override
    public void createDrops(TileEntityMiner miner) {
        if (!miner.hasPumps()) {
            return;
        }
        miner.pumpFluid(this.getCache(miner.func_145831_w()));
    }

    @Override
    public List<ItemStack> getDrops() {
        return new ArrayList<ItemStack>();
    }

    @Override
    public NBTTagCompound save() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("BlockID", this.state.func_177230_c().getRegistryName().toString());
        nbt.func_74768_a("Metadata", this.state.func_177230_c().func_176201_c(this.state));
        nbt.func_74772_a("Location", this.pos.func_177986_g());
        return nbt;
    }

    @Override
    public boolean loadFromNBT(NBTTagCompound nbt) {
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(nbt.func_74779_i("BlockID")));
        if (block == Blocks.field_150350_a || block == null) {
            return false;
        }
        this.pos = BlockPos.func_177969_a((long)nbt.func_74763_f("Location"));
        this.state = block.func_176203_a(nbt.func_74762_e("Metadata"));
        return true;
    }

    @Override
    public byte getID() {
        return 2;
    }

    public FluidStack getCache(World world) {
        if (this.buildCache && this.cache != null) {
            return this.cache;
        }
        this.buildCache = true;
        IFluidHandler handler = FluidHelper.getBlockHandler(this.state, world, this.pos);
        if (handler != null) {
            this.cache = handler.drain(Integer.MAX_VALUE, false);
        }
        return this.cache;
    }
}

