/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.sounds;

import ic2.api.classic.audio.PositionSpec;
import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.audio.ISoundTracker;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.misc.StackUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ChainsawHandler
implements ISoundTracker {
    EntityLivingBase base;
    byte lastHeld = 0;
    AudioSource source;

    public ChainsawHandler(EntityLivingBase living) {
        this.base = living;
    }

    @Override
    public void onTick() {
        if (this.lastHeld == 0) {
            ItemStack stack = this.base.func_184614_ca();
            if (StackUtil.isStackEqual(stack, Ic2Items.chainSaw)) {
                this.lastHeld = 1;
                this.source = IC2.audioManager.createSource(this.base, PositionSpec.Hand, Ic2Sounds.chainsawIdle, true, false, IC2.audioManager.getDefaultVolume());
                if (this.source != null) {
                    this.source.play();
                }
                return;
            }
            stack = this.base.func_184592_cb();
            if (StackUtil.isStackEqual(stack, Ic2Items.chainSaw)) {
                this.lastHeld = (byte)2;
                this.source = IC2.audioManager.createSource(this.base, PositionSpec.Hand, Ic2Sounds.chainsawIdle, true, false, IC2.audioManager.getDefaultVolume());
                if (this.source != null) {
                    this.source.play();
                }
            }
        } else {
            ItemStack stack = this.base.func_184586_b(this.lastHeld == 1 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
            if (!StackUtil.isStackEqual(stack, Ic2Items.chainSaw)) {
                this.lastHeld = 0;
                if (this.source != null) {
                    this.source.remove();
                    this.source = null;
                }
                IC2.audioManager.playOnce(this.base, PositionSpec.Hand, Ic2Sounds.chainsawStop, true, IC2.audioManager.getDefaultVolume());
            }
            if (this.source != null && this.source.isRemoved()) {
                this.source = null;
                this.lastHeld = 0;
            }
        }
    }

    @Override
    public boolean isValid(World world) {
        return this.base.func_130014_f_() == world || !this.base.field_70128_L;
    }
}

