/*
 * Decompiled with CFR 0.152.
 */
package ic2.jeiIntigration.core.machine.uraniumEnricher;

import ic2.core.block.machine.high.TileEntityUraniumEnricher;
import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.platform.registry.Ic2Resources;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.config.GuiUtils;

public class UraniumEnricherWrapper
extends BlankRecipeWrapper {
    IUranium uranium;
    IDrawable fuel;

    public UraniumEnricherWrapper(IUranium uran) {
        this.uranium = uran;
    }

    public void getIngredients(IIngredients arg0) {
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
        inputs.add(Arrays.asList(this.uranium.getIngridient()));
        inputs.add(Arrays.asList(TileEntityUraniumEnricher.getReference()));
        arg0.setInputLists(ItemStack.class, inputs);
        arg0.setOutput(ItemStack.class, (Object)this.uranium.getUraniumIngot());
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.fuel != null) {
            float[] color = this.uranium.getReEnrichedColor().getColorComponents(new float[3]);
            GlStateManager.func_179124_c((float)color[0], (float)color[1], (float)color[2]);
            float amount = (float)this.uranium.getIngrientPoints() / 1000.0f;
            int value = (int)(amount * 33.0f);
            this.fuel.draw(minecraft, 47, 34 - value);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (mouseX >= 46 && mouseX <= 50 && mouseY >= 0 && mouseY <= 35) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("Enrichment Points Per Item: " + this.uranium.getIngrientPoints());
            list.add("Points per Ingot: 100 Points");
            GuiUtils.drawHoveringText((ItemStack)ItemStack.field_190927_a, list, (int)mouseX, (int)mouseY, (int)minecraft.field_71443_c, (int)minecraft.field_71440_d, (int)-1, (FontRenderer)minecraft.field_71466_p);
        }
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
    }

    public void setHelper(IGuiHelper helper) {
        float amount = (float)this.uranium.getIngrientPoints() / 1000.0f;
        this.fuel = helper.createDrawable(Ic2Resources.uraniumEnricher, 176, 75, 4, (int)(amount * 33.0f));
    }
}

