/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.io;

import com.gmail.trentech.pjc.core.ConfigManager;
import com.gmail.trentech.pjw.Main;
import com.gmail.trentech.pjw.io.SpongeData;
import com.gmail.trentech.pjw.io.WorldData;
import java.io.File;
import java.io.IOException;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.plugin.PluginContainer;

public class Migrator {
    public static void init() {
        String defaultWorld = ConfigManager.get((PluginContainer)Main.getPlugin()).getConfig().getNode(new Object[]{"options", "world_root"}).getString();
        File directory = new File(Sponge.getGame().getSavesDirectory().toFile(), defaultWorld);
        if (!directory.exists()) {
            return;
        }
        for (File world : directory.listFiles()) {
            SpongeData spongeData;
            WorldData worldData;
            if (!world.isDirectory() || !(worldData = new WorldData(world)).exists()) continue;
            String name = world.getName();
            if (!worldData.isCorrectLevelName()) {
                Main.instance().getLog().warn(worldData.getLevelName() + " -> " + name + ": Repairing level name mismatch");
                try {
                    worldData.setLevelName(name);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            File dest = world;
            if (name.equalsIgnoreCase(defaultWorld)) {
                name = world.getName() + "_1";
                Main.instance().getLog().warn(defaultWorld + " -> " + name + ": Repairing duplicate world name");
                try {
                    worldData.setLevelName(name);
                    dest = new File(new File(Sponge.getGame().getSavesDirectory().toFile(), defaultWorld), name);
                    world.renameTo(dest);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if ((spongeData = new SpongeData(dest)).exists()) continue;
            Main.instance().getLog().warn(name + ": Requires importing. /world import " + name + " <type> <generator>");
        }
    }
}

