/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.extra.modifier.skylands;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.vector.Vector3i;
import com.flowpowered.noise.Noise;
import com.flowpowered.noise.NoiseQuality;
import com.flowpowered.noise.module.Module;
import com.flowpowered.noise.module.modifier.Exponent;
import com.flowpowered.noise.module.modifier.ScaleBias;
import com.flowpowered.noise.module.modifier.ScalePoint;
import com.flowpowered.noise.module.source.Perlin;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.extra.modifier.skylands.SkylandsUtil;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.ImmutableBiomeVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.gen.GenerationPopulator;

@Deprecated
public class SkylandsTerrainGenerator
implements GenerationPopulator {
    private static final int MID_POINT = 64;
    private static final int UPPER_SIZE = 48;
    private static final int LOWER_SIZE = 36;
    public static final int MAX_HEIGHT = 111;
    public static final int MIN_HEIGHT = 29;
    private static final Vector3i NOISE_SAMPLING_RATE = new Vector3i(4, 8, 4);
    private static final double THRESHOLD = 0.215;
    private final Perlin inputNoise = new Perlin();
    private final VerticalScaling outputNoise = new VerticalScaling();
    private final OreNoise[] oreNoises;

    public SkylandsTerrainGenerator() {
        this.inputNoise.setFrequency(0.04);
        this.inputNoise.setLacunarity(2.0);
        this.inputNoise.setNoiseQuality(NoiseQuality.STANDARD);
        this.inputNoise.setPersistence(0.5);
        this.inputNoise.setOctaveCount(4);
        ScaleBias scaleBias = new ScaleBias();
        scaleBias.setSourceModule(0, this.inputNoise);
        scaleBias.setScale(1.0 / SkylandsTerrainGenerator.getOutputMax(this.inputNoise));
        scaleBias.setBias(0.0);
        ScalePoint scalePoint = new ScalePoint();
        scalePoint.setSourceModule(0, scaleBias);
        scalePoint.setXScale(0.5);
        scalePoint.setYScale(1.0);
        scalePoint.setZScale(0.5);
        Exponent exponent = new Exponent();
        exponent.setSourceModule(0, scalePoint);
        exponent.setExponent(2.2);
        this.outputNoise.setSourceModule(0, exponent);
        this.outputNoise.setMidPoint(64.0);
        this.outputNoise.setUpperSize(48.0);
        this.outputNoise.setLowerSize(36.0);
        this.outputNoise.setDegree(2.0);
        this.oreNoises = new OreNoise[]{new OreNoise(GenericMath.lerp(0.215, 1.0, 0.07), 0.3, 0.64, BlockTypes.DIAMOND_ORE), new OreNoise(GenericMath.lerp(0.215, 1.0, 0.06), 0.27, 0.64, BlockTypes.GOLD_ORE), new OreNoise(GenericMath.lerp(0.215, 1.0, 0.05), 0.26, 0.64, BlockTypes.REDSTONE_ORE), new OreNoise(GenericMath.lerp(0.215, 1.0, 0.0), 0.25, 0.64, BlockTypes.IRON_ORE), new OreNoise(GenericMath.lerp(0.215, 1.0, 0.0), 0.22, 0.63, BlockTypes.COAL_ORE)};
    }

    @Override
    public void populate(World world, MutableBlockVolume buffer, ImmutableBiomeVolume biomes) {
        Vector3i min = buffer.getBlockMin();
        Vector3i max = buffer.getBlockMax();
        if (max.getY() < 29 || min.getY() > 111) {
            return;
        }
        long seed = world.getProperties().getSeed();
        int intSeed = (int)(seed >> 32 ^ seed);
        this.inputNoise.setSeed(intSeed);
        Vector3i size = buffer.getBlockSize();
        int xSize = size.getX();
        int ySize = size.getY();
        int zSize = size.getZ();
        int xMin = min.getX();
        int yMin = min.getY();
        int zMin = min.getZ();
        int xMax = max.getX();
        int yMax = max.getY();
        int zMax = max.getZ();
        double[] noise = SkylandsUtil.fastNoise(this.outputNoise, NOISE_SAMPLING_RATE, xMin, yMin, zMin, xSize, ySize, zSize);
        for (int zz = zMin; zz <= zMax; ++zz) {
            for (int yy = yMin; yy <= yMax; ++yy) {
                block2: for (int xx = xMin; xx <= xMax; ++xx) {
                    double density = noise[SkylandsUtil.index3D(xx - xMin, yy - yMin, zz - zMin, xSize + 1, ySize + 1)];
                    if (!(density >= 0.215)) continue;
                    for (OreNoise oreNoise : this.oreNoises) {
                        if (!oreNoise.hasBlock(density, xx, yy, zz, intSeed)) continue;
                        buffer.setBlockType(xx, yy, zz, oreNoise.getBlock());
                        continue block2;
                    }
                    buffer.setBlockType(xx, yy, zz, BlockTypes.STONE);
                }
            }
        }
    }

    private static double getOutputMax(Perlin perlin) {
        int octaves = perlin.getOctaveCount();
        double persistence = perlin.getPersistence();
        double max = 0.0;
        for (int i = 0; i < octaves; ++i) {
            max += Math.pow(persistence, i);
        }
        return max;
    }

    static class OreNoise {
        private final double densityThreshold;
        private final double frequency;
        private final double noiseThreshold;
        private final BlockType block;
        private final int seedModifier;

        OreNoise(double densityThreshold, double frequency, double noiseThreshold, BlockType block) {
            this.densityThreshold = densityThreshold;
            this.frequency = frequency;
            this.noiseThreshold = noiseThreshold;
            this.block = block;
            this.seedModifier = block.getName().hashCode();
        }

        boolean hasBlock(double density, double x, double y, double z, int seed) {
            return density >= this.densityThreshold && Noise.gradientCoherentNoise3D(x * this.frequency, y * this.frequency, z * this.frequency, seed ^ this.seedModifier, NoiseQuality.FAST) >= this.noiseThreshold;
        }

        BlockType getBlock() {
            return this.block;
        }
    }

    private static class VerticalScaling
    extends Module {
        private double midPoint;
        private double upperScale;
        private double lowerScale;
        private double degree;

        VerticalScaling() {
            super(1);
        }

        @Override
        public int getSourceModuleCount() {
            return 1;
        }

        void setMidPoint(double midPoint) {
            this.midPoint = midPoint;
        }

        void setUpperSize(double upperScale) {
            this.upperScale = upperScale;
        }

        void setLowerSize(double lowerScale) {
            this.lowerScale = lowerScale;
        }

        void setDegree(double degree) {
            this.degree = degree;
        }

        @Override
        public double getValue(double x, double y, double z) {
            double scale = (y -= this.midPoint) >= 0.0 ? 1.0 - Math.pow(y / this.upperScale, this.degree) : 1.0 - Math.pow(-y / this.lowerScale, this.degree);
            return scale > 0.0 ? this.sourceModule[0].getValue(x, y, z) * scale : 0.0;
        }
    }
}

