/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableFlyingData;
import org.spongepowered.api.data.manipulator.mutable.entity.FlyingData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeFlyingData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class FlyingDataProcessor
extends AbstractEntitySingleDataProcessor<Entity, Boolean, Value<Boolean>, FlyingData, ImmutableFlyingData> {
    public FlyingDataProcessor() {
        super(Entity.class, Keys.IS_FLYING);
    }

    @Override
    protected Value<Boolean> constructValue(Boolean actualValue) {
        return new SpongeValue<Boolean>(Keys.IS_FLYING, actualValue);
    }

    @Override
    protected FlyingData createManipulator() {
        return new SpongeFlyingData();
    }

    @Override
    protected boolean set(Entity entity, Boolean value) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            entityPlayer.field_71075_bZ.field_75100_b = value;
            entityPlayer.func_71016_p();
        } else {
            entity.field_70160_al = value;
        }
        return true;
    }

    @Override
    protected Optional<Boolean> getVal(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return Optional.of(((EntityPlayer)entity).field_71075_bZ.field_75100_b);
        }
        return Optional.of(entity.field_70160_al);
    }

    @Override
    protected ImmutableValue<Boolean> constructImmutableValue(Boolean value) {
        return ImmutableSpongeValue.cachedOf(Keys.IS_FLYING, false, value);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

