/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.util;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.AbstractChestHorse;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ContainerBeacon;
import net.minecraft.inventory.ContainerBrewingStand;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.ContainerDispenser;
import net.minecraft.inventory.ContainerEnchantment;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.ContainerHopper;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.item.inventory.BlockCarrier;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.inventory.ContainerBridge;
import org.spongepowered.common.bridge.inventory.LensProviderBridge;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.inventory.DefaultSingleBlockCarrier;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.VanillaContainerAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.slots.CraftingOutputAdapter;
import org.spongepowered.common.item.inventory.custom.CustomContainer;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.comp.CraftingInventoryLens;
import org.spongepowered.common.item.inventory.lens.comp.GridInventoryLens;
import org.spongepowered.common.item.inventory.lens.comp.Inventory2DLens;
import org.spongepowered.common.item.inventory.lens.impl.DefaultEmptyLens;
import org.spongepowered.common.item.inventory.lens.impl.DelegatingLens;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotCollection;
import org.spongepowered.common.item.inventory.lens.impl.comp.CraftingInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.GridInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.Inventory2DLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.MainPlayerInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.OrderedInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.minecraft.BrewingStandInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.minecraft.FurnaceInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.minecraft.LargeChestInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.minecraft.PlayerInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.minecraft.container.ContainerLens;
import org.spongepowered.common.item.inventory.lens.impl.slots.CraftingOutputSlotLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.slots.SlotLensImpl;
import org.spongepowered.common.mixin.core.inventory.ContainerAccessor;
import org.spongepowered.common.mixin.core.inventory.ContainerBrewingStandAccessor;
import org.spongepowered.common.mixin.core.inventory.ContainerDispenserAccessor;
import org.spongepowered.common.mixin.core.inventory.ContainerFurnaceAccessor;
import org.spongepowered.common.mixin.core.inventory.ContainerHopperAccessor;
import org.spongepowered.common.mixin.core.inventory.ContainerHorseInventoryAccessor;
import org.spongepowered.common.mixin.core.inventory.ContainerMerchantAccessor;
import org.spongepowered.common.mixin.core.inventory.ContainerRepairAccessor;
import org.spongepowered.common.mixin.core.inventory.SlotCraftingAccessor;

public final class ContainerUtil {
    private static final Random RANDOM = new Random();

    private ContainerUtil() {
    }

    public static Container fromNative(net.minecraft.inventory.Container container) {
        return (Container)container;
    }

    public static net.minecraft.inventory.Container toNative(Container container) {
        return (net.minecraft.inventory.Container)container;
    }

    public static ContainerBridge toMixin(net.minecraft.inventory.Container container) {
        return (ContainerBridge)container;
    }

    public static net.minecraft.inventory.Container fromMixin(ContainerBridge container) {
        return (net.minecraft.inventory.Container)container;
    }

    public static void performBlockInventoryDrops(WorldServer worldServer, double x, double y, double z, IInventory inventory) {
        PhaseContext<?> context;
        IPhaseState currentState = context.state;
        context = PhaseTracker.getInstance().getCurrentContext();
        if (currentState.tracksBlockSpecificDrops(context)) {
            ArrayListMultimap<BlockPos, EntityItem> multimap = context.getBlockItemDropSupplier().get();
            BlockPos pos = new BlockPos(x, y, z);
            Collection itemStacks = multimap.get((Object)pos);
            for (int j = 0; j < inventory.func_70302_i_(); ++j) {
                ItemStack itemStack = inventory.func_70301_a(j);
                if (itemStack.func_190926_b()) continue;
                float f = RANDOM.nextFloat() * 0.8f + 0.1f;
                float f1 = RANDOM.nextFloat() * 0.8f + 0.1f;
                float f2 = RANDOM.nextFloat() * 0.8f + 0.1f;
                while (!itemStack.func_190926_b()) {
                    int i = RANDOM.nextInt(21) + 10;
                    EntityItem entityitem = new EntityItem((net.minecraft.world.World)worldServer, x + (double)f, y + (double)f1, z + (double)f2, itemStack.func_77979_a(i));
                    entityitem.field_70159_w = RANDOM.nextGaussian() * 0.05;
                    entityitem.field_70181_x = RANDOM.nextGaussian() * 0.05 + 0.2;
                    entityitem.field_70179_y = RANDOM.nextGaussian() * 0.05;
                    itemStacks.add(entityitem);
                }
            }
            return;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((net.minecraft.world.World)worldServer, (double)x, (double)y, (double)z, (ItemStack)itemStack);
        }
    }

    public static Lens generateLens(net.minecraft.inventory.Container container, SlotProvider slots) {
        Map viewed = container.field_75151_b.stream().collect(Collectors.groupingBy(i -> Optional.ofNullable(i.field_75224_c), LinkedHashMap::new, Collectors.toList()));
        int index = 0;
        CraftingInventoryData crafting = new CraftingInventoryData();
        ArrayList<Lens> lenses = new ArrayList<Lens>();
        for (Map.Entry entry : viewed.entrySet()) {
            List slotList = (List)entry.getValue();
            int slotCount = slotList.size();
            IInventory subInventory = ((Optional)entry.getKey()).orElse(null);
            Lens lens = ContainerUtil.generateAdapterLens(slots, index, crafting, slotList, subInventory);
            if (lens == null && subInventory instanceof LensProviderBridge) {
                Fabric keyFabric = (Fabric)subInventory;
                lens = ((LensProviderBridge)subInventory).bridge$rootLens(keyFabric, new VanillaContainerAdapter(keyFabric, container));
            }
            if (lens == null || lens.slotCount() != slotCount) {
                if (subInventory instanceof InventoryCraftResult) {
                    net.minecraft.inventory.Slot slot = (net.minecraft.inventory.Slot)slotList.get(0);
                    lens = new CraftingOutputSlotLensImpl(index, item -> slot.func_75214_a((ItemStack)item), itemType -> slot.func_75214_a((ItemStack)org.spongepowered.api.item.inventory.ItemStack.of(itemType, 1)));
                } else if (subInventory instanceof InventoryCrafting) {
                    InventoryCrafting craftGrid = (InventoryCrafting)subInventory;
                    lens = new GridInventoryLensImpl(index, craftGrid.func_174922_i(), craftGrid.func_174923_h(), slots);
                } else if (slotCount == 1) {
                    lens = new SlotLensImpl(index);
                } else if (subInventory instanceof InventoryBasic && subInventory.getClass().isAnonymousClass()) {
                    switch (subInventory.func_70005_c_()) {
                        case "Enchant": 
                        case "Repair": {
                            lens = new OrderedInventoryLensImpl(index, slotCount, slots);
                            break;
                        }
                        default: {
                            lens = new OrderedInventoryLensImpl(index, slotCount, slots);
                            break;
                        }
                    }
                } else {
                    lens = new OrderedInventoryLensImpl(index, slotCount, slots);
                }
            }
            lenses.add(lens);
            index += slotCount;
        }
        ArrayList<Lens> additional = new ArrayList<Lens>();
        try {
            if (crafting.out != null && crafting.base != null && crafting.grid != null) {
                if (crafting.base + crafting.grid.func_70302_i_() <= container.field_75151_b.size()) {
                    additional.add(new CraftingInventoryLensImpl((int)crafting.out, (int)crafting.base, crafting.grid.func_174922_i(), crafting.grid.func_174923_h(), slots));
                }
            } else if (crafting.base != null && crafting.grid != null) {
                additional.add(new GridInventoryLensImpl(crafting.base, crafting.grid.func_174922_i(), crafting.grid.func_174923_h(), slots));
            }
        }
        catch (Exception e) {
            SpongeImpl.getLogger().error("Error while creating CraftingInventoryLensImpl or GridInventoryLensImpl for " + container.getClass().getName(), (Throwable)e);
        }
        return new ContainerLens(container.field_75151_b.size(), container.getClass(), slots, lenses, additional);
    }

    @Nullable
    private static Lens generateAdapterLens(SlotProvider slots, int index, CraftingInventoryData crafting, List<net.minecraft.inventory.Slot> slotList, @Nullable IInventory subInventory) {
        if (!(subInventory instanceof InventoryAdapter)) {
            return null;
        }
        Lens adapterLens = ((InventoryAdapter)subInventory).bridge$getRootLens();
        if (adapterLens == null) {
            return null;
        }
        if (subInventory.func_70302_i_() == 0) {
            return new DefaultEmptyLens((InventoryAdapter)subInventory);
        }
        if (adapterLens instanceof PlayerInventoryLens) {
            if (slotList.size() == 36) {
                return new DelegatingLens(index, new MainPlayerInventoryLensImpl(index, slots, true), slots);
            }
            return null;
        }
        if (subInventory instanceof InventoryCraftResult) {
            net.minecraft.inventory.Slot slot = slotList.get(0);
            adapterLens = new CraftingOutputSlotLensImpl(index, item -> slot.func_75214_a((ItemStack)item), itemType -> slot.func_75214_a((ItemStack)org.spongepowered.api.item.inventory.ItemStack.of(itemType, 1)));
            if (slot instanceof SlotCraftingAccessor) {
                crafting.out = index;
                if (crafting.base == null) {
                    crafting.base = index + 1;
                    crafting.grid = ((SlotCraftingAccessor)slot).accessor$getCraftingMatrix();
                }
            }
        }
        if (subInventory instanceof InventoryCrafting) {
            crafting.base = index;
            crafting.grid = (InventoryCrafting)subInventory;
        }
        return new DelegatingLens(index, slotList, adapterLens, slots);
    }

    private static Lens copyLens(int base, InventoryAdapter adapter, Lens lens, SlotCollection slots) {
        if (lens instanceof LargeChestInventoryLens) {
            return new LargeChestInventoryLens(base, adapter, slots);
        }
        if (lens instanceof FurnaceInventoryLens) {
            return new FurnaceInventoryLens(base, adapter, slots);
        }
        if (lens instanceof BrewingStandInventoryLens) {
            return new BrewingStandInventoryLens(base, adapter, slots);
        }
        if (lens instanceof CraftingInventoryLens) {
            return new CraftingInventoryLensImpl(0, base, ((GridInventoryLens)lens).getWidth(), ((GridInventoryLens)lens).getHeight(), (SlotProvider)slots);
        }
        if (lens instanceof GridInventoryLens) {
            return new GridInventoryLensImpl(base, ((GridInventoryLens)lens).getWidth(), ((GridInventoryLens)lens).getHeight(), ((GridInventoryLens)lens).getStride(), (SlotProvider)slots);
        }
        if (lens instanceof Inventory2DLens) {
            return new Inventory2DLensImpl(base, ((Inventory2DLens)lens).getWidth(), ((Inventory2DLens)lens).getHeight(), slots);
        }
        return null;
    }

    public static SlotProvider countSlots(net.minecraft.inventory.Container container, Fabric fabric) {
        if (container instanceof LensProviderBridge) {
            return ((LensProviderBridge)container).bridge$slotProvider(fabric, (InventoryAdapter)container);
        }
        SlotCollection.Builder builder = new SlotCollection.Builder();
        for (net.minecraft.inventory.Slot slot : container.field_75151_b) {
            if (slot instanceof SlotCrafting) {
                builder.add(1, CraftingOutputAdapter.class, i -> new CraftingOutputSlotLensImpl(i, item -> slot.func_75214_a((ItemStack)item), itemType -> slot.func_75214_a((ItemStack)org.spongepowered.api.item.inventory.ItemStack.of(itemType, 1))));
                continue;
            }
            builder.add(1);
        }
        return builder.build();
    }

    public static InventoryArchetype getArchetype(net.minecraft.inventory.Container container) {
        if (container instanceof ContainerChest) {
            IInventory inventory = ((ContainerChest)container).func_85151_d();
            if (inventory instanceof TileEntityChest) {
                return InventoryArchetypes.CHEST;
            }
            if (inventory instanceof InventoryLargeChest) {
                return InventoryArchetypes.DOUBLE_CHEST;
            }
            return InventoryArchetypes.UNKNOWN;
        }
        if (container instanceof ContainerHopper) {
            return InventoryArchetypes.HOPPER;
        }
        if (container instanceof ContainerDispenser) {
            return InventoryArchetypes.DISPENSER;
        }
        if (container instanceof ContainerWorkbench) {
            return InventoryArchetypes.WORKBENCH;
        }
        if (container instanceof ContainerFurnace) {
            return InventoryArchetypes.FURNACE;
        }
        if (container instanceof ContainerEnchantment) {
            return InventoryArchetypes.ENCHANTING_TABLE;
        }
        if (container instanceof ContainerRepair) {
            return InventoryArchetypes.ANVIL;
        }
        if (container instanceof ContainerBrewingStand) {
            return InventoryArchetypes.BREWING_STAND;
        }
        if (container instanceof ContainerBeacon) {
            return InventoryArchetypes.BEACON;
        }
        if (container instanceof ContainerHorseInventoryAccessor) {
            AbstractHorse horse = ((ContainerHorseInventoryAccessor)container).accessor$getHorseCarrier();
            if (horse instanceof AbstractChestHorse && ((AbstractChestHorse)horse).func_190695_dh()) {
                return InventoryArchetypes.HORSE_WITH_CHEST;
            }
            return InventoryArchetypes.HORSE;
        }
        if (container instanceof ContainerMerchant) {
            return InventoryArchetypes.VILLAGER;
        }
        if (container instanceof ContainerPlayer) {
            return InventoryArchetypes.PLAYER;
        }
        return InventoryArchetypes.UNKNOWN;
    }

    @Nullable
    public static Carrier getCarrier(final Container container) {
        Location<World> loc;
        Object player;
        if (container instanceof BlockCarrier) {
            return (BlockCarrier)((Object)container);
        }
        if (container instanceof CustomContainer) {
            return ((CustomContainer)((Object)container)).inv.getCarrier();
        }
        if (container instanceof ContainerChest) {
            IInventory inventory = ((ContainerChest)container).func_85151_d();
            if (inventory instanceof Carrier) {
                if (inventory instanceof TileEntityChest) {
                    return (Carrier)inventory;
                }
                if (inventory instanceof InventoryLargeChest) {
                    return (BlockCarrier)inventory;
                }
            }
            return ContainerUtil.carrierOrNull(inventory);
        }
        if (container instanceof ContainerHopperAccessor) {
            return ContainerUtil.carrierOrNull(((ContainerHopperAccessor)((Object)container)).accessor$getHopperInventory());
        }
        if (container instanceof ContainerDispenserAccessor) {
            return ContainerUtil.carrierOrNull(((ContainerDispenserAccessor)((Object)container)).accessor$getDispenserInventory());
        }
        if (container instanceof ContainerFurnaceAccessor) {
            return ContainerUtil.carrierOrNull(((ContainerFurnaceAccessor)((Object)container)).accessor$getFurnaceInventory());
        }
        if (container instanceof ContainerBrewingStandAccessor) {
            return ContainerUtil.carrierOrNull(((ContainerBrewingStandAccessor)((Object)container)).accessor$getBrewingStandInventory());
        }
        if (container instanceof ContainerBeacon) {
            return ContainerUtil.carrierOrNull(((ContainerBeacon)container).func_180611_e());
        }
        if (container instanceof ContainerHorseInventoryAccessor) {
            return (Carrier)((ContainerHorseInventoryAccessor)((Object)container)).accessor$getHorseCarrier();
        }
        if (container instanceof ContainerMerchantAccessor && ((ContainerMerchantAccessor)((Object)container)).accessor$getMerchantCarrier() instanceof Carrier) {
            return (Carrier)((ContainerMerchantAccessor)((Object)container)).accessor$getMerchantCarrier();
        }
        if (container instanceof ContainerRepairAccessor && (player = ((ContainerRepairAccessor)((Object)container)).accessor$getPlayerCarrier()) instanceof EntityPlayerMP) {
            return (Carrier)player;
        }
        if (container instanceof ContainerAccessor) {
            for (final net.minecraft.inventory.Slot slot : ((ContainerAccessor)((Object)container)).accessor$getSlots()) {
                if (slot.field_75224_c instanceof Carrier) {
                    return (Carrier)slot.field_75224_c;
                }
                if (!(slot.field_75224_c instanceof TileEntity)) continue;
                return new DefaultSingleBlockCarrier(){

                    @Override
                    public Location<World> getLocation() {
                        BlockPos pos = ((TileEntity)slot.field_75224_c).func_174877_v();
                        return new Location<World>((World)((TileEntity)slot.field_75224_c).func_145831_w(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    }

                    public CarriedInventory<?> getInventory() {
                        return (CarriedInventory)((Object)container);
                    }
                };
            }
        }
        if ((loc = ((ContainerBridge)((Object)container)).bridge$getOpenLocation()) != null) {
            return new DefaultSingleBlockCarrier(){

                @Override
                public Location<World> getLocation() {
                    return loc;
                }

                public CarriedInventory<?> getInventory() {
                    return (CarriedInventory)((Object)container);
                }
            };
        }
        return null;
    }

    private static Carrier carrierOrNull(IInventory inventory) {
        if (inventory instanceof Carrier) {
            return (Carrier)inventory;
        }
        if (inventory instanceof CarriedInventory) {
            Optional carrier = ((CarriedInventory)inventory).getCarrier();
            return carrier.orElse(null);
        }
        return null;
    }

    public static Slot getSlot(net.minecraft.inventory.Container container, int slot) {
        return ((ContainerBridge)container).bridge$getContainerSlot(slot);
    }

    private static class CraftingInventoryData {
        @Nullable
        private Integer out;
        @Nullable
        private Integer base;
        @Nullable
        private InventoryCrafting grid;

        private CraftingInventoryData() {
        }
    }
}

