/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.scoreboard;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.scoreboard.IScoreCriteria;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.scoreboard.critieria.Criteria;
import org.spongepowered.api.scoreboard.critieria.Criterion;
import org.spongepowered.common.registry.type.AbstractPrefixAlternateCatalogTypeRegistryModule;

@RegisterCatalog(value=Criteria.class)
public final class CriteriaRegistryModule
extends AbstractPrefixAlternateCatalogTypeRegistryModule<Criterion> {
    private final Map<String, Criterion> teamKillMappings = new HashMap<String, Criterion>();
    private final Map<String, Criterion> killedByTeamMappings = new HashMap<String, Criterion>();

    public static CriteriaRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    CriteriaRegistryModule() {
        super("minecraft", new String[]{"minecraft"}, id -> id.replace("_count", "s"));
    }

    @Override
    public void registerDefaults() {
        IScoreCriteria.field_96643_a.values().forEach(scoreCriterion -> {
            Criterion criterion = (Criterion)scoreCriterion;
            this.register(criterion);
            criterion.getTeamColor().ifPresent(color -> {
                this.teamKillMappings.put(color.getId(), criterion);
                this.killedByTeamMappings.put(color.getId(), criterion);
            });
        });
    }

    public Map<String, Criterion> getTeamKillMappings() {
        return this.teamKillMappings;
    }

    public Map<String, Criterion> getKilledByTeamMappings() {
        return this.killedByTeamMappings;
    }

    private static final class Holder {
        static final CriteriaRegistryModule INSTANCE = new CriteriaRegistryModule();

        private Holder() {
        }
    }
}

