/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.resourcepack;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.annotation.Nullable;
import org.spongepowered.common.resourcepack.SpongeResourcePack;

public class SpongeWorldResourcePack
extends SpongeResourcePack {
    private final String path;
    private final URI uri;
    public static final String LEVEL_PACK_PROTOCOL = "level://";

    public SpongeWorldResourcePack(String levelUri, @Nullable String hash) {
        super(hash);
        this.path = levelUri.substring(LEVEL_PACK_PROTOCOL.length());
        try {
            this.uri = URI.create(LEVEL_PACK_PROTOCOL + URLEncoder.encode(this.path, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public SpongeWorldResourcePack(URI levelUri, @Nullable String hash) {
        super(hash);
        String path = levelUri.toString().substring(LEVEL_PACK_PROTOCOL.length());
        try {
            this.path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        this.uri = levelUri;
    }

    @Override
    public String getName() {
        return "resourceszip";
    }

    @Override
    public String getUrlString() {
        return LEVEL_PACK_PROTOCOL + this.path;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }
}

