/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.placeholder;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.placeholder.PlaceholderContext;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.text.placeholder.SpongePlaceholderContext;

public class SpongePlaceholderContextBuilder
implements PlaceholderContext.Builder {
    @Nullable
    private Supplier<Object> associatedObjectSupplier;
    @Nullable
    private String argument = null;

    @Override
    public PlaceholderContext.Builder setAssociatedObject(@Nullable Object associatedObject) {
        if (associatedObject == null) {
            this.associatedObjectSupplier = null;
        } else {
            if (associatedObject instanceof Supplier) {
                return this.setAssociatedObject((Supplier)associatedObject);
            }
            if (associatedObject instanceof ConsoleSource) {
                this.associatedObjectSupplier = () -> (ConsoleSource)SpongeImpl.getServer();
            } else {
                if (associatedObject instanceof Player) {
                    return this.setAssociatedObject((Player)associatedObject);
                }
                if (associatedObject instanceof World) {
                    UUID uuid = ((World)associatedObject).getUniqueId();
                    this.associatedObjectSupplier = () -> SpongeImpl.getGame().getServer().getWorld(uuid).orElse(null);
                } else if (associatedObject instanceof Entity) {
                    Entity entity = (Entity)associatedObject;
                    UUID worldUuid = entity.getWorld().getUniqueId();
                    UUID entityUuid = ((Entity)associatedObject).getUniqueId();
                    this.associatedObjectSupplier = () -> SpongeImpl.getGame().getServer().getWorld(worldUuid).flatMap(x -> x.getEntity(entityUuid)).orElse(null);
                } else {
                    WeakReference<Object> objectWeakReference = new WeakReference<Object>(associatedObject);
                    this.associatedObjectSupplier = objectWeakReference::get;
                }
            }
        }
        return this;
    }

    @Override
    public PlaceholderContext.Builder setAssociatedObject(@Nullable Supplier<Object> associatedObjectSupplier) {
        this.associatedObjectSupplier = associatedObjectSupplier;
        return this;
    }

    @Override
    public PlaceholderContext.Builder setArgumentString(@Nullable String argument) {
        this.argument = argument == null || argument.isEmpty() ? null : argument;
        return this;
    }

    @Override
    public PlaceholderContext build() throws IllegalStateException {
        return new SpongePlaceholderContext(this.associatedObjectSupplier, this.argument);
    }

    @Override
    public PlaceholderContext.Builder from(PlaceholderContext value) {
        Preconditions.checkArgument((boolean)(value instanceof SpongePlaceholderContext), (Object)"Must be a SpongePlaceholderContext");
        this.argument = value.getArgumentString().orElse(null);
        this.associatedObjectSupplier = ((SpongePlaceholderContext)value).getAssociatedObjectSupplier();
        return this;
    }

    @Override
    public PlaceholderContext.Builder reset() {
        this.associatedObjectSupplier = null;
        this.argument = null;
        return this;
    }
}

