/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.plugin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Optional;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.plugin.PluginManager;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Singleton
public class SpongeModPluginManager
implements PluginManager {
    @Override
    public Optional<PluginContainer> getPlugin(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(id);
        if (container == null) {
            for (ModContainer mod : Loader.instance().getModList()) {
                if (!mod.getModId().equalsIgnoreCase(id)) continue;
                container = mod;
                break;
            }
        }
        return Optional.ofNullable((PluginContainer)container);
    }

    @Override
    public Collection<PluginContainer> getPlugins() {
        return ImmutableList.copyOf((Collection)Loader.instance().getActiveModList());
    }

    @Override
    public Optional<PluginContainer> fromInstance(Object instance) {
        Preconditions.checkNotNull((Object)instance, (Object)"instance");
        if (instance instanceof PluginContainer) {
            return Optional.of((PluginContainer)instance);
        }
        return Optional.ofNullable((PluginContainer)Loader.instance().getReversedModObjectList().get(instance));
    }

    @Override
    public boolean isLoaded(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        return Loader.isModLoaded((String)id);
    }
}

