/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler.magicavoxel;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import lumien.randomthings.RandomThings;
import lumien.randomthings.config.Features;
import lumien.randomthings.handler.magicavoxel.ClientModelRequest;
import lumien.randomthings.handler.magicavoxel.MagicaVoxelLoader;
import lumien.randomthings.handler.magicavoxel.MagicaVoxelModel;
import lumien.randomthings.network.PacketHandler;
import lumien.randomthings.network.messages.magicavoxel.MessageModelRequest;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.Level;

public class ClientModelLibrary {
    Timer cleanUpTimer;
    Cache<String, MagicaVoxelModel> modelCache;
    Map<String, ClientModelRequest> modelRequests;
    static ClientModelLibrary INSTANCE;

    public ClientModelLibrary() {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        cacheBuilder.expireAfterAccess(5L, TimeUnit.MINUTES);
        cacheBuilder.removalListener((RemovalListener)new RemovalListener<String, MagicaVoxelModel>(){

            public void onRemoval(RemovalNotification<String, MagicaVoxelModel> notification) {
                MagicaVoxelModel model = (MagicaVoxelModel)notification.getValue();
                model.cleanUp();
            }
        });
        this.cleanUpTimer = new Timer("ModelCleanupTimer", true);
        this.cleanUpTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        ClientModelLibrary.getInstance().modelCache.cleanUp();
                    }
                });
            }
        }, 1000L, 10000L);
        this.modelCache = cacheBuilder.build();
        this.modelRequests = new HashMap<String, ClientModelRequest>();
    }

    private MagicaVoxelModel loadModelFromFile(String modelName) {
        File modelFolder = new File(Minecraft.func_71410_x().field_71412_D, "voxmodels");
        if (modelFolder.isDirectory()) {
            File modelRequested = new File(modelFolder, modelName + ".vox");
            File paletteRequested = new File(modelFolder, modelName + ".act");
            if (modelRequested.isFile() && paletteRequested.isFile()) {
                try {
                    return MagicaVoxelLoader.getModel(modelRequested, paletteRequested);
                }
                catch (Exception e) {
                    RandomThings.instance.logger.log(Level.ERROR, "Error loading model from file: " + modelName);
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public MagicaVoxelModel getModel(String modelName) {
        MagicaVoxelModel model = (MagicaVoxelModel)this.modelCache.getIfPresent((Object)modelName);
        if (model != null) {
            return model;
        }
        if (this.modelRequests.containsKey(modelName)) {
            ClientModelRequest request = this.modelRequests.get(modelName);
            if (request.getState() == ClientModelRequest.STATE.FINISHED) {
                try {
                    model = MagicaVoxelLoader.getModel(new ByteArrayInputStream(request.modelData), new ByteArrayInputStream(request.paletteData));
                    this.modelCache.put((Object)modelName, (Object)model);
                    this.modelRequests.remove(modelName);
                }
                catch (Exception e) {
                    RandomThings.instance.logger.log(Level.ERROR, "Error loading model from server: " + modelName);
                    e.printStackTrace();
                    if (model != null) {
                        model.cleanUp();
                    }
                    request.state = ClientModelRequest.STATE.NOT_AVAILABLE;
                    request.modelData = null;
                    request.paletteData = null;
                    return null;
                }
                if (Features.MODEL_CLIENT_SAVING) {
                    File modelFolder = new File(Minecraft.func_71410_x().field_71412_D, "voxmodels");
                    if (!modelFolder.exists()) {
                        modelFolder.mkdir();
                    }
                    if (modelFolder.isDirectory()) {
                        try {
                            File modelFile = new File(modelFolder, modelName + ".vox");
                            File paletteFile = new File(modelFolder, modelName + ".act");
                            if (!modelFile.exists()) {
                                FileOutputStream modelOutputStream = new FileOutputStream(modelFile);
                                modelOutputStream.write(request.modelData);
                                modelOutputStream.close();
                            }
                            if (!paletteFile.exists()) {
                                FileOutputStream paletteOutputStream = new FileOutputStream(paletteFile);
                                paletteOutputStream.write(request.paletteData);
                                paletteOutputStream.close();
                            }
                        }
                        catch (Exception e) {
                            RandomThings.instance.logger.log(Level.ERROR, "Error saving " + modelName + " to File");
                            e.printStackTrace();
                        }
                    }
                }
                return model;
            }
            return null;
        }
        model = this.loadModelFromFile(modelName);
        if (model != null) {
            if (this.modelRequests.containsKey(modelName)) {
                this.modelRequests.remove(modelName);
            }
            RandomThings.instance.logger.log(Level.DEBUG, "Loaded " + modelName + " from File");
            this.modelCache.put((Object)modelName, (Object)model);
            return model;
        }
        RandomThings.instance.logger.log(Level.DEBUG, "Requesting " + modelName + " from Server");
        ClientModelRequest request = new ClientModelRequest();
        request.setState(ClientModelRequest.STATE.SEND_REQUEST);
        MessageModelRequest requestMessage = new MessageModelRequest(modelName);
        PacketHandler.INSTANCE.sendToServer(requestMessage);
        this.modelRequests.put(modelName, request);
        return null;
    }

    public static ClientModelLibrary getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClientModelLibrary();
        }
        return INSTANCE;
    }

    public void updateRequest(String modelName, int modelSize, int paletteSize) {
        if (this.modelRequests.containsKey(modelName)) {
            ClientModelRequest request = this.modelRequests.get(modelName);
            request.updateRequest(modelSize, paletteSize);
        }
    }

    public void reset() {
        this.modelRequests.clear();
        this.modelCache.invalidateAll();
    }

    public void addModelData(String modelName, byte[] data) {
        if (this.modelRequests.containsKey(modelName)) {
            int progress;
            ClientModelRequest request = this.modelRequests.get(modelName);
            if (request.getState() != ClientModelRequest.STATE.RECEIVING) {
                RandomThings.instance.logger.log(Level.ERROR, "Receiving data for invalid request state: " + (Object)((Object)request.getState()));
            }
            if ((progress = request.bytesReceived) < request.modelData.length) {
                for (int i = 0; i < data.length; ++i) {
                    request.modelData[progress + i] = data[i];
                }
            } else if (progress < request.modelData.length + request.paletteData.length) {
                for (int i = 0; i < data.length; ++i) {
                    request.paletteData[progress - request.modelSize + i] = data[i];
                }
            }
            request.bytesReceived = progress += data.length;
            if (progress >= request.modelSize + request.paletteSize) {
                request.setState(ClientModelRequest.STATE.FINISHED);
            }
        }
    }
}

