/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.gui.tinker.frame;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.machinemuse.numina.client.gui.scrollable.ScrollableFrame;
import net.machinemuse.numina.math.Colour;
import net.machinemuse.numina.math.geometry.MusePoint2D;
import net.machinemuse.numina.math.geometry.MuseRect;
import net.machinemuse.numina.math.geometry.MuseRelativeRect;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.machinemuse.powersuits.gui.tinker.frame.ColourPickerFrame;
import net.machinemuse.powersuits.gui.tinker.frame.CosmeticPresetSelectionSubframe;
import net.machinemuse.powersuits.gui.tinker.frame.ItemSelectionFrame;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class CosmeticPresetContainer
extends ScrollableFrame {
    public ItemSelectionFrame itemSelect;
    public ColourPickerFrame colourSelect;
    public MusePoint2D topleft;
    public MusePoint2D bottomright;
    public Integer lastItemSlot;
    public List<CosmeticPresetSelectionSubframe> presetFrames;
    protected boolean enabled;
    protected boolean visibile;

    public CosmeticPresetContainer(ItemSelectionFrame itemSelect, ColourPickerFrame colourSelect, MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour) {
        super(topleft, bottomright, borderColour, insideColour);
        this.itemSelect = itemSelect;
        this.colourSelect = colourSelect;
        this.topleft = topleft;
        this.bottomright = bottomright;
        this.lastItemSlot = null;
        this.presetFrames = this.getPresetFrames();
        this.visibile = true;
        this.enabled = true;
    }

    @Nonnull
    public ItemStack getItem() {
        return this.itemSelect.getSelectedItem() != null ? this.itemSelect.getSelectedItem().getItem() : ItemStack.field_190927_a;
    }

    @Nullable
    public Integer getItemSlot() {
        return this.itemSelect.getSelectedItem() != null ? Integer.valueOf(this.itemSelect.getSelectedItem().inventorySlot) : null;
    }

    public List<CosmeticPresetSelectionSubframe> getPresetFrames() {
        ArrayList<CosmeticPresetSelectionSubframe> cosmeticFrameList = new ArrayList<CosmeticPresetSelectionSubframe>();
        CosmeticPresetSelectionSubframe prev = null;
        for (String name : MPSConfig.getCosmeticPresets(this.getItem()).keySet()) {
            CosmeticPresetSelectionSubframe newFrame;
            prev = newFrame = this.createNewFrame(name, prev);
            cosmeticFrameList.add(newFrame);
        }
        return cosmeticFrameList;
    }

    public CosmeticPresetSelectionSubframe createNewFrame(String label, CosmeticPresetSelectionSubframe prev) {
        MuseRelativeRect newborder = new MuseRelativeRect(this.border.left() + 8.0, this.border.top() + 10.0, this.border.right(), this.border.top() + 24.0);
        newborder.setBelow((MuseRect)(prev != null ? prev.border : null));
        return new CosmeticPresetSelectionSubframe(label, new MusePoint2D(newborder.left(), newborder.centery()), this.itemSelect, newborder);
    }

    public void onMouseDown(double x, double y, int button) {
        if (this.enabled && button == 0) {
            for (CosmeticPresetSelectionSubframe frame : this.presetFrames) {
                if (!frame.hitbox(x, y)) continue;
                return;
            }
        }
    }

    public void update(double mouseX, double mouseY) {
        super.update(mouseX, mouseY);
        if (this.enabled && !Objects.equals(this.lastItemSlot, this.getItemSlot())) {
            this.lastItemSlot = this.getItemSlot();
            this.presetFrames = this.getPresetFrames();
            double x = 0.0;
            for (CosmeticPresetSelectionSubframe subframe : this.presetFrames) {
                x += subframe.border.bottom();
            }
            this.totalsize = (int)x;
            if (this.colourSelect.decrAbove > -1) {
                this.colourSelect.decrAbove = -1;
            }
        }
    }

    public void hide() {
        this.visibile = false;
    }

    public void show() {
        this.visibile = true;
    }

    public boolean isVisibile() {
        return this.visibile;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void draw() {
        if (this.visibile) {
            super.preDraw();
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)(-this.currentscrollpixels), (double)0.0);
            for (CosmeticPresetSelectionSubframe f : this.presetFrames) {
                f.draw();
            }
            GL11.glPopMatrix();
            super.postDraw();
        }
    }
}

