/*
 * Decompiled with CFR 0.152.
 */
package com.carrot.carrotshop.shop;

import com.carrot.carrotshop.CarrotShop;
import com.carrot.carrotshop.Lang;
import com.carrot.carrotshop.ShopsData;
import com.carrot.carrotshop.ShopsLogs;
import com.carrot.carrotshop.shop.Shop;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.Stack;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.block.tileentity.carrier.TileEntityCarrier;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.type.InventoryRow;
import org.spongepowered.api.item.inventory.type.TileEntityInventory;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@ConfigSerializable
public class iBuy
extends Shop {
    @Setting
    private Inventory itemsTemplate;
    @Setting
    private float price;
    private static String type = "iBuy";

    public iBuy() {
    }

    public iBuy(Player player, Location<World> sign) throws ExceptionInInitializerError {
        super(sign);
        if (!player.hasPermission("carrotshop.admin.ibuy")) {
            throw new ExceptionInInitializerError(Lang.SHOP_PERM.replace("%type%", type));
        }
        Stack<Location<World>> locations = ShopsData.getItemLocations(player);
        if (locations.isEmpty()) {
            throw new ExceptionInInitializerError(Lang.SHOP_CHEST.replace("%type%", type));
        }
        Optional chestOpt = locations.peek().getTileEntity();
        if (!chestOpt.isPresent() || !(chestOpt.get() instanceof TileEntityCarrier)) {
            throw new ExceptionInInitializerError(Lang.SHOP_CHEST.replace("%type%", type));
        }
        TileEntityInventory items = ((TileEntityCarrier)chestOpt.get()).getInventory();
        if (items.totalItems() == 0) {
            throw new ExceptionInInitializerError(Lang.SHOP_CHEST_EMPTY);
        }
        this.price = iBuy.getPrice(sign);
        if (this.price < 0.0f) {
            throw new ExceptionInInitializerError(Lang.SHOP_PRICE);
        }
        this.itemsTemplate = ((Inventory.Builder)Inventory.builder().from((Object)items)).build((Object)CarrotShop.getInstance());
        for (Inventory item : items.slots()) {
            if (!item.peek().isPresent()) continue;
            this.itemsTemplate.offer((ItemStack)item.peek().get());
        }
        ShopsData.clearItemLocations(player);
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, Lang.SHOP_DONE.replace("%type%", type)}));
        this.done(player);
        this.info(player);
    }

    public iBuy(Location<World> sign, ItemStackSnapshot item) {
        super(sign);
        this.price = iBuy.getPrice(sign);
        if (this.price < 0.0f) {
            this.price = 0.0f;
        }
        this.itemsTemplate = Inventory.builder().build((Object)CarrotShop.getInstance());
        this.itemsTemplate.offer(item.createStack());
    }

    @Override
    public void info(Player player) {
        Text.Builder builder = Text.builder();
        builder.append(new Text[]{Text.of((String)Lang.split(Lang.SHOP_FORMAT_BUY, "%items%", 0).replace("%price%", this.formatPrice(this.price)))});
        builder.append(new Text[]{iBuy.formatInventoryNames(this.itemsTemplate)});
        builder.append(new Text[]{Text.of((String)Lang.split(Lang.SHOP_FORMAT_BUY, "%items%", 1).replace("%price%", this.formatPrice(this.price)))});
        player.sendMessage(builder.build());
        this.update();
    }

    @Override
    public boolean trigger(Player player) {
        UniqueAccount buyerAccount = (UniqueAccount)CarrotShop.getEcoService().getOrCreateAccount(player.getUniqueId()).get();
        TransactionResult result = buyerAccount.withdraw(this.getCurrency(), BigDecimal.valueOf(this.price), CarrotShop.getCause());
        if (result.getResult() != ResultType.SUCCESS) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, Lang.SHOP_MONEY}));
            return false;
        }
        Inventory inv = player.getInventory().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_TYPE.of(InventoryRow.class)});
        for (Inventory item : this.itemsTemplate.slots()) {
            if (!item.peek().isPresent()) continue;
            inv.offer(((ItemStack)item.peek().get()).copy()).getRejectedItems().forEach(action -> iBuy.putItemInWorld(action, (Location<World>)player.getLocation()));
        }
        ShopsLogs.log(this.getOwner(), player, "buy", super.getLocation(), Optional.of(Float.valueOf(this.price)), this.getRawCurrency(), Optional.of(this.itemsTemplate), Optional.empty());
        String recap = Lang.SHOP_RECAP_BUY.replace("%price%", this.formatPrice(this.price));
        player.sendMessage(Text.of((Object[])new Object[]{Lang.split(recap, "%items%", 0), iBuy.formatInventoryNames(this.itemsTemplate), Lang.split(recap, "%items%", 1)}));
        return true;
    }
}

