/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.storage;

import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.common.caching.FactionsCache;
import io.github.aquerr.eaglefactions.common.storage.FactionStorage;
import io.github.aquerr.eaglefactions.common.storage.PlayerStorage;
import io.github.aquerr.eaglefactions.common.storage.file.hocon.ConfigurateHelper;
import io.github.aquerr.eaglefactions.common.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;

public class BackupStorage {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_hh-mm-ss");
    private final Path backupsPath;
    private final FactionStorage factionStorage;
    private final PlayerStorage playerStorage;

    public BackupStorage(FactionStorage factionStorage, PlayerStorage playerStorage, Path configPath) {
        this.backupsPath = configPath.resolve("backups");
        this.factionStorage = factionStorage;
        this.playerStorage = playerStorage;
    }

    public boolean createBackup() {
        try {
            Path backupDirPath = this.backupsPath.resolve("backup-" + DATE_TIME_FORMATTER.format(LocalDateTime.now()));
            FileUtils.createDirectoryIfNotExists(this.backupsPath);
            FileUtils.createDirectoryIfNotExists(backupDirPath);
            Path factionsDir = backupDirPath.resolve("factions");
            Path playersDir = backupDirPath.resolve("players");
            FileUtils.createDirectoryIfNotExists(factionsDir);
            FileUtils.createDirectoryIfNotExists(playersDir);
            Set<Faction> factions = this.factionStorage.getFactions();
            for (Faction faction : factions) {
                Path factionFilePath = factionsDir.resolve(faction.getName().toLowerCase() + ".conf");
                HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setDefaultOptions(ConfigurateHelper.getDefaultOptions())).setPath(factionFilePath)).build();
                ConfigurationNode configurationNode = configurationLoader.createEmptyNode();
                ConfigurateHelper.putFactionInNode(configurationNode, faction);
                configurationLoader.save(configurationNode);
            }
            Set<FactionPlayer> players = this.playerStorage.getServerPlayers();
            for (FactionPlayer factionPlayer : players) {
                Path playerFile = playersDir.resolve(factionPlayer.getUniqueId().toString() + ".conf");
                HoconConfigurationLoader playerConfigLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(playerFile)).build();
                ConfigurationNode playerNode = playerConfigLoader.createEmptyNode();
                ConfigurateHelper.putPlayerInNode(playerNode, factionPlayer);
                playerConfigLoader.save(playerNode);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(backupDirPath.toAbsolutePath().toString() + ".zip");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedOutputStream);
            File file = backupDirPath.toFile();
            this.zipFile(file, file.getName(), zipOutputStream);
            bufferedOutputStream.flush();
            zipOutputStream.close();
            bufferedOutputStream.close();
            fileOutputStream.close();
            FileUtils.deleteDirectoryRecursive(backupDirPath.toFile());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<String> listBackups() {
        ArrayList<String> backupsNames = new ArrayList<String>();
        File backupDirectory = this.backupsPath.toFile();
        File[] backupFiles = backupDirectory.listFiles();
        if (backupFiles == null) {
            return backupsNames;
        }
        for (File file : backupFiles) {
            if (!file.getName().endsWith(".zip")) continue;
            backupsNames.add(file.getName());
        }
        return backupsNames;
    }

    public boolean restoreBackup(String backupName) throws IOException {
        Path backupPath = this.backupsPath.resolve(backupName);
        if (Files.notExists(backupPath, new LinkOption[0])) {
            return false;
        }
        Path destPath = this.backupsPath;
        File destDir = destPath.toFile();
        byte[] buffer = new byte[1024];
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(backupPath.toFile()));
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            int len;
            File newFile = BackupStorage.newFile(destDir, zipEntry);
            if (zipEntry.isDirectory()) {
                FileUtils.createDirectoryIfNotExists(newFile.toPath());
                zipEntry = zipInputStream.getNextEntry();
                continue;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(newFile);
            while ((len = zipInputStream.read(buffer)) > 0) {
                fileOutputStream.write(buffer, 0, len);
            }
            fileOutputStream.close();
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.closeEntry();
        zipInputStream.close();
        Path backupTempDirectory = destPath.resolve(FileUtils.getFileNameWithoutExtension(backupName));
        Path factionsDirPath = backupTempDirectory.resolve("factions");
        File factionsDir = factionsDirPath.toFile();
        File[] factionsFiles = factionsDir.listFiles();
        ArrayList<Faction> factions = new ArrayList<Faction>();
        if (factionsFiles != null) {
            for (File file : factionsFiles) {
                HoconConfigurationLoader hoconConfigurationLoader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setDefaultOptions(ConfigurateHelper.getDefaultOptions())).setFile(file)).build();
                ConfigurationNode configurationNode = hoconConfigurationLoader.load();
                try {
                    Faction faction = ConfigurateHelper.getFactionFromNode(configurationNode);
                    factions.add(faction);
                }
                catch (ObjectMappingException e) {
                    e.printStackTrace();
                }
            }
        }
        ArrayList<FactionPlayer> players = new ArrayList<FactionPlayer>();
        Path playersDirPath = backupTempDirectory.resolve("players");
        File playersDir = playersDirPath.toFile();
        File[] playerFiles = playersDir.listFiles();
        if (playerFiles != null) {
            for (File file : playerFiles) {
                FactionPlayer factionPlayer = ConfigurateHelper.getPlayerFromFile(file);
                if (factionPlayer == null) continue;
                players.add(factionPlayer);
            }
        }
        this.factionStorage.deleteFactions();
        this.playerStorage.deletePlayers();
        for (Faction faction : factions) {
            this.factionStorage.saveFaction(faction);
            FactionsCache.saveFaction(faction);
        }
        this.playerStorage.savePlayers(players);
        FileUtils.deleteDirectoryRecursive(backupTempDirectory.toFile());
        return true;
    }

    public static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    private void zipFile(File file, String fileName, ZipOutputStream zipOutputStream) throws IOException {
        int length;
        if (file.isHidden()) {
            return;
        }
        if (file.isDirectory()) {
            File[] children;
            if (fileName.endsWith("/")) {
                zipOutputStream.putNextEntry(new ZipEntry(fileName));
                zipOutputStream.closeEntry();
            } else {
                zipOutputStream.putNextEntry(new ZipEntry(fileName + "/"));
                zipOutputStream.closeEntry();
            }
            for (File childFile : children = file.listFiles()) {
                this.zipFile(childFile, fileName + "/" + childFile.getName(), zipOutputStream);
            }
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOutputStream.putNextEntry(zipEntry);
        byte[] bytes = new byte[2048];
        while ((length = bufferedInputStream.read(bytes)) >= 0) {
            zipOutputStream.write(bytes, 0, length);
        }
        bufferedInputStream.close();
        fileInputStream.close();
    }
}

