/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.storage.serializers;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.reflect.TypeToken;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.common.storage.serializers.EFTypeSerializers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.spongepowered.api.util.TypeTokens;

public class ClaimTypeSerializer
implements TypeSerializer<Claim> {
    public Claim deserialize(TypeToken<?> type, ConfigurationNode value) throws ObjectMappingException {
        HashSet<UUID> owners;
        boolean isAccessibleByFaction;
        Vector3i chunkPosition = Vector3i.ZERO;
        UUID worldUniqueId = new UUID(0L, 0L);
        try {
            worldUniqueId = (UUID)value.getNode(new Object[]{"worldUUID"}).getValue(TypeTokens.UUID_TOKEN, (Object)new UUID(0L, 0L));
            chunkPosition = (Vector3i)value.getNode(new Object[]{"chunkPosition"}).getValue(TypeTokens.VECTOR_3I_TOKEN, (Object)Vector3i.ZERO);
            isAccessibleByFaction = value.getNode(new Object[]{"accessibleByFaction"}).getBoolean(true);
            owners = new HashSet<UUID>(value.getNode(new Object[]{"owners"}).getList(TypeTokens.UUID_TOKEN, Collections.EMPTY_LIST));
        }
        catch (Exception e) {
            throw new ObjectMappingException("Could not deserialize the claim: " + worldUniqueId.toString() + "|" + chunkPosition, (Throwable)e);
        }
        return new Claim(worldUniqueId, chunkPosition, owners, isAccessibleByFaction);
    }

    public void serialize(TypeToken<?> type, Claim obj, ConfigurationNode value) throws ObjectMappingException {
        if (obj == null) {
            return;
        }
        value.getNode(new Object[]{"worldUUID"}).setValue(TypeTokens.UUID_TOKEN, (Object)obj.getWorldUUID());
        value.getNode(new Object[]{"chunkPosition"}).setValue(TypeTokens.VECTOR_3I_TOKEN, (Object)obj.getChunkPosition());
        value.getNode(new Object[]{"accessibleByFaction"}).setValue((Object)obj.isAccessibleByFaction());
        value.getNode(new Object[]{"owners"}).setValue(EFTypeSerializers.UUID_LIST_TYPE_TOKEN, new ArrayList<UUID>(obj.getOwners()));
    }

    public static Vector3i deserializeVector3i(String vectorAsString) {
        Objects.requireNonNull(vectorAsString);
        String[] vectors = vectorAsString.replace("(", "").replace(")", "").replace(" ", "").split(",");
        int x = Integer.parseInt(vectors[0]);
        int y = Integer.parseInt(vectors[1]);
        int z = Integer.parseInt(vectors[2]);
        return Vector3i.from((int)x, (int)y, (int)z);
    }
}

