/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.item;

import crafttweaker.api.data.IData;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IMutableItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.mc1120.data.NBTConverter;
import crafttweaker.mc1120.data.NBTUpdater;
import crafttweaker.mc1120.item.MCItemStack;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class MCMutableItemStack
extends MCItemStack
implements IMutableItemStack {
    public MCMutableItemStack(ItemStack itemStack) {
        super(itemStack);
        NBTTagCompound nbt = itemStack.func_77978_p();
        this.tag = nbt == null ? null : NBTConverter.from((NBTBase)nbt, false);
    }

    @Override
    public void shrink(int quality) {
        this.origin.func_190918_g(quality);
    }

    @Override
    public void grow(int quality) {
        this.origin.func_190917_f(quality);
    }

    @Override
    public boolean attemptDamageItem(int amount, IPlayer player) {
        EntityPlayer mcplayer = CraftTweakerMC.getPlayer(player);
        return this.origin.func_96631_a(amount, mcplayer != null ? mcplayer.field_70170_p.field_73012_v : new Random(), mcplayer instanceof EntityPlayerMP ? (EntityPlayerMP)mcplayer : null);
    }

    @Override
    public IItemStack withTag(IData tag, boolean matchTagExact) {
        this.matchTagExact = matchTagExact;
        this.tag = tag;
        this.origin.func_77982_d(CraftTweakerMC.getNBTCompound(tag));
        return this;
    }

    @Override
    public IItemStack updateTag(IData tagUpdate, boolean matchTagExact) {
        this.matchTagExact = matchTagExact;
        if (this.tag == null) {
            if (this.origin.func_77978_p() == null) {
                return this.withTag(tagUpdate, matchTagExact);
            }
            this.tag = NBTConverter.from((NBTBase)this.origin.func_77978_p(), false);
        }
        NBTUpdater.updateMap(this.origin.func_77978_p(), tagUpdate);
        this.tag = this.tag.update(tagUpdate);
        return this;
    }

    @Override
    public IItemStack withEmptyTag() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.tag = NBTConverter.from((NBTBase)nbt, false);
        this.origin.func_77982_d(nbt);
        return this;
    }

    @Override
    public IItemStack removeTag(String tag) {
        if (tag == null) {
            this.origin.func_77982_d(null);
        } else {
            this.origin.func_77978_p().func_82580_o(tag);
        }
        this.tag = NBTConverter.from((NBTBase)this.origin.func_77978_p(), false);
        return this;
    }

    @Override
    public IItemStack withAmount(int amount) {
        this.origin.func_190920_e(amount);
        return this;
    }

    @Override
    public IItemStack withDamage(int damage) {
        this.origin.func_77964_b(damage);
        return this;
    }

    @Override
    public IItemStack withDisplayName(String name) {
        NBTTagCompound tagComp = !this.origin.func_77942_o() || this.origin.func_77978_p() == null ? new NBTTagCompound() : this.origin.func_77978_p();
        NBTTagCompound display = !tagComp.func_74764_b("display") || !(tagComp.func_74781_a("display") instanceof NBTTagCompound) ? new NBTTagCompound() : (NBTTagCompound)tagComp.func_74781_a("display");
        display.func_74778_a("Name", name);
        tagComp.func_74782_a("display", (NBTBase)display);
        this.origin.func_77982_d(tagComp);
        return this;
    }

    @Override
    public IItemStack withLore(String[] lore) {
        NBTTagCompound tagComp = !this.origin.func_77942_o() || this.origin.func_77978_p() == null ? new NBTTagCompound() : this.origin.func_77978_p();
        NBTTagCompound display = !tagComp.func_74764_b("display") || !(tagComp.func_74781_a("display") instanceof NBTTagCompound) ? new NBTTagCompound() : (NBTTagCompound)tagComp.func_74781_a("display");
        NBTTagList loreList = !display.func_74764_b("Lore") || !(display.func_74781_a("Lore") instanceof NBTTagList) ? new NBTTagList() : (NBTTagList)display.func_74781_a("Lore");
        for (String s : lore) {
            loreList.func_74742_a((NBTBase)new NBTTagString(s));
        }
        display.func_74782_a("Lore", (NBTBase)loreList);
        tagComp.func_74782_a("display", (NBTBase)display);
        this.origin.func_77982_d(tagComp);
        return this;
    }

    @Override
    public IItemStack copy() {
        return new MCItemStack(this.origin.func_77946_l());
    }

    @Override
    public void damageItem(int amount, IEntity entity) {
        if (entity.getInternal() instanceof EntityLivingBase) {
            this.origin.func_77972_a(amount, (EntityLivingBase)entity.getInternal());
        }
    }

    @Override
    public Object getInternal() {
        return this.origin;
    }
}

