/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.recipe;

import io.github.phantamanta44.libnine.recipe.IRcp;
import io.github.phantamanta44.libnine.recipe.IRecipeList;
import io.github.phantamanta44.libnine.recipe.IRecipeManager;
import io.github.phantamanta44.libnine.recipe.input.IRcpIn;
import io.github.phantamanta44.libnine.recipe.output.IRcpOut;
import io.github.phantamanta44.libnine.recipe.type.SmeltingRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class RecipeManager
implements IRecipeManager {
    private final Map<Class<?>, RecipeListImpl> recipeLists = new HashMap();

    public RecipeManager() {
        this.addType(SmeltingRecipe.class);
    }

    @Override
    public <T, I extends IRcpIn<T>, O extends IRcpOut<?>, R extends IRcp<T, I, O>> IRecipeList<T, I, O, R> getRecipeList(Class<R> type) {
        return this.recipeLists.get(type);
    }

    @Override
    public void addType(Class<? extends IRcp<?, ?, ?>> type) {
        this.recipeLists.putIfAbsent(type, new RecipeListImpl());
    }

    private static class RecipeListImpl
    implements IRecipeList {
        private final Collection<IRcp> recipes = new ArrayList<IRcp>();

        RecipeListImpl() {
        }

        @Nullable
        public IRcp findRecipe(Object input) {
            return this.recipes.stream().filter(r -> r.input().matches((Object)input)).findAny().orElse(null);
        }

        public Collection recipes() {
            return this.recipes;
        }

        public void add(IRcp recipe) {
            this.recipes.add(recipe);
        }
    }
}

