/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.helper;

import io.github.phantamanta44.libnine.item.L9ItemSubs;
import io.github.phantamanta44.libnine.util.IDisplayableMatcher;
import io.github.phantamanta44.libnine.util.world.WorldBlockPos;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;

public class ItemUtils {
    public static final short WILDCARD_META = Short.MAX_VALUE;

    public static boolean matchesWithWildcard(ItemStack a, ItemStack b) {
        return a.func_77973_b().equals(b.func_77973_b()) && (a.func_77960_j() == Short.MAX_VALUE || b.func_77960_j() == Short.MAX_VALUE || a.func_77960_j() == b.func_77960_j()) && (a.func_77942_o() ? b.func_77942_o() && b.func_77978_p().equals((Object)a.func_77978_p()) : !b.func_77942_o());
    }

    public static IDisplayableMatcher<ItemStack> matchesWithWildcard(ItemStack stack) {
        return IDisplayableMatcher.of(() -> stack.func_77960_j() == Short.MAX_VALUE ? new ItemStack(stack.func_77973_b(), stack.func_190916_E(), 0) : stack, s -> ItemUtils.matchesWithWildcard(stack, s));
    }

    public static String getColouredName(ItemStack stack) {
        return stack.func_77973_b().getForgeRarity(stack).getColor() + stack.func_82833_r();
    }

    public static String getUnlocalizedBlockName(WorldBlockPos pos) {
        Block block = pos.getBlock();
        return Item.func_150898_a((Block)block).func_77667_c(block.getPickBlock(pos.getBlockState(), null, pos.getWorld(), pos.getPos(), null));
    }

    public static String getLocalizedBlockName(WorldBlockPos pos) {
        Block block = pos.getBlock();
        return Item.func_150898_a((Block)block).func_77653_i(block.getPickBlock(pos.getBlockState(), null, pos.getWorld(), pos.getPos(), null));
    }

    public static String getColouredBlockName(WorldBlockPos pos) {
        Block block = pos.getBlock();
        Item item = Item.func_150898_a((Block)block);
        ItemStack stack = block.getPickBlock(pos.getBlockState(), null, pos.getWorld(), pos.getPos(), null);
        return item.getForgeRarity(stack).getColor() + item.func_77653_i(stack);
    }

    public static String getLocalizedSubName(L9ItemSubs item, int meta) {
        return I18n.func_74838_a((String)String.format("item.%s%d.name", item.getRegistryName(), meta));
    }

    public static NBTTagCompound getOrCreateTag(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag;
    }
}

