/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.math;

import io.github.phantamanta44.libnine.util.tuple.IPair;
import net.minecraft.util.math.Vec3i;

public class MathUtils {
    public static final double R2D_D = 57.29577951308232;
    public static final double D2R_D = Math.PI / 180;
    public static final float PI_F = (float)Math.PI;
    public static final float R2D_F = 57.295776f;
    public static final float D2R_F = (float)Math.PI / 180;

    public static int clamp(int n, int lower, int upper) {
        return Math.max(Math.min(n, upper), lower);
    }

    public static float clamp(float n, float lower, float upper) {
        return Math.max(Math.min(n, upper), lower);
    }

    public static double clamp(double n, double lower, double upper) {
        return Math.max(Math.min(n, upper), lower);
    }

    public static long clamp(long n, long lower, long upper) {
        return Math.max(Math.min(n, upper), lower);
    }

    public static IPair<Vec3i, Vec3i> computeCuboid(Iterable<Vec3i> points) {
        int minX = 0;
        int minY = 0;
        int minZ = 0;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        for (Vec3i point : points) {
            int x = point.func_177958_n();
            int y = point.func_177956_o();
            int z = point.func_177952_p();
            if (x < minX) {
                minX = x;
            } else if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            } else if (y > maxY) {
                maxY = y;
            }
            if (z < minZ) {
                minZ = z;
                continue;
            }
            if (z <= maxZ) continue;
            maxZ = z;
        }
        return IPair.of(new Vec3i(minX, minY, minZ), new Vec3i(maxX, maxY, maxZ));
    }
}

