/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import openblocks.common.block.BlockBigButton;
import openmods.geometry.BlockSpaceTransform;
import openmods.geometry.Orientation;

public class BlockBigButtonWood
extends BlockBigButton {
    private static final AxisAlignedBB COLLISION_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);

    private boolean hasStuckArrows(IBlockState state, World world, BlockPos pos) {
        Orientation orientation = this.getOrientation(state);
        AxisAlignedBB checkAabb = BlockSpaceTransform.instance.mapBlockToWorld(orientation, COLLISION_AABB).func_186670_a(pos);
        List collidingArrows = world.func_72872_a(EntityArrow.class, checkAabb);
        return !collidingArrows.isEmpty();
    }

    @Override
    protected void updateAfterTimeout(IBlockState state, World world, BlockPos pos) {
        if (this.hasStuckArrows(state, world, pos)) {
            this.scheduleUpdate(world, pos);
        } else {
            this.pop(state, world, pos);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!world.field_72995_K && !((Boolean)state.func_177229_b(POWERED)).booleanValue() && this.hasStuckArrows(state, world, pos)) {
            this.push(state, world, pos);
        }
    }
}

