/*
 * Decompiled with CFR 0.152.
 */
package de.randombyte.lottery;

import com.google.inject.Inject;
import de.randombyte.lottery.Config;
import de.randombyte.lottery.DrawEvent;
import de.randombyte.lottery.InternalData;
import de.randombyte.lottery.LotteryKt;
import de.randombyte.lottery.commands.AddPotCommand;
import de.randombyte.lottery.commands.BuyTicketCommand;
import de.randombyte.lottery.commands.InfoCommand;
import de.randombyte.lottery.shaded.bstats.sponge.Metrics;
import de.randombyte.lottery.shaded.kosp.PlayerExecutedCommand;
import de.randombyte.lottery.shaded.kosp.config.ConfigManager;
import de.randombyte.lottery.shaded.kosp.extensions.StringsKt;
import de.randombyte.lottery.shaded.kosp.extensions.UuidsKt;
import de.randombyte.lottery.shaded.kotlin.Metadata;
import de.randombyte.lottery.shaded.kotlin.TuplesKt;
import de.randombyte.lottery.shaded.kotlin.collections.CollectionsKt;
import de.randombyte.lottery.shaded.kotlin.collections.MapsKt;
import de.randombyte.lottery.shaded.kotlin.jvm.functions.Function0;
import de.randombyte.lottery.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import de.randombyte.lottery.shaded.kotlin.jvm.internal.Intrinsics;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.text.Text;

@Plugin(id="lottery", name="Lottery", version="2.0.2", authors={"RandomByte"})
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0012J\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H\u0007J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020&H\u0007J\u0016\u0010'\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0012J\u000e\u0010+\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0012J\u000e\u0010,\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0012R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006."}, d2={"Lde/randombyte/lottery/Lottery;", "", "logger", "Lorg/slf4j/Logger;", "configLoader", "Lninja/leaping/configurate/loader/ConfigurationLoader;", "Lninja/leaping/configurate/commented/CommentedConfigurationNode;", "pluginContainer", "Lorg/spongepowered/api/plugin/PluginContainer;", "bstats", "Lde/randombyte/lottery/shaded/bstats/sponge/Metrics;", "(Lorg/slf4j/Logger;Lninja/leaping/configurate/loader/ConfigurationLoader;Lorg/spongepowered/api/plugin/PluginContainer;Lorg/bstats/sponge/Metrics;)V", "PLUGIN_CAUSE", "Lorg/spongepowered/api/event/cause/Cause;", "getPLUGIN_CAUSE", "()Lorg/spongepowered/api/event/cause/Cause;", "configManager", "Lde/randombyte/lottery/shaded/kosp/config/ConfigManager;", "Lde/randombyte/lottery/Config;", "getConfigManager", "()Lde/randombyte/kosp/config/ConfigManager;", "getLogger", "()Lorg/slf4j/Logger;", "nextDraw", "Ljava/time/Instant;", "getNextDraw", "()Ljava/time/Instant;", "setNextDraw", "(Ljava/time/Instant;)V", "draw", "", "config", "getDurationUntilDraw", "Ljava/time/Duration;", "onInit", "event", "Lorg/spongepowered/api/event/game/state/GameInitializationEvent;", "onReload", "Lorg/spongepowered/api/event/game/GameReloadEvent;", "playerWon", "uuid", "Ljava/util/UUID;", "resetPot", "resetTasks", "setDurationUntilDraw", "Companion", "lottery"})
public final class Lottery {
    @NotNull
    private final ConfigManager<Config> configManager;
    @NotNull
    private final Cause PLUGIN_CAUSE;
    @NotNull
    public Instant nextDraw;
    @NotNull
    private final Logger logger;
    private final Metrics bstats;
    @NotNull
    public static final String ID = "lottery";
    @NotNull
    public static final String NAME = "Lottery";
    @NotNull
    public static final String VERSION = "2.0.2";
    @NotNull
    public static final String AUTHOR = "RandomByte";
    @NotNull
    public static final String ROOT_PERMISSION = "lottery";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ConfigManager<Config> getConfigManager() {
        return this.configManager;
    }

    @NotNull
    public final Cause getPLUGIN_CAUSE() {
        return this.PLUGIN_CAUSE;
    }

    @NotNull
    public final Instant getNextDraw() {
        Instant instant = this.nextDraw;
        if (instant == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nextDraw");
        }
        return instant;
    }

    public final void setNextDraw(@NotNull Instant instant) {
        Intrinsics.checkParameterIsNotNull(instant, "<set-?>");
        this.nextDraw = instant;
    }

    @Listener
    public final void onInit(@NotNull GameInitializationEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        this.configManager.generate();
        Sponge.getCommandManager().register((Object)this, (CommandCallable)CommandSpec.builder().child((CommandCallable)CommandSpec.builder().permission("lottery.ticket.buy").executor((CommandExecutor)new BuyTicketCommand(this.configManager, this.PLUGIN_CAUSE)).arguments(GenericArguments.optional((CommandElement)GenericArguments.integer((Text)StringsKt.toText("ticketAmount")))).build(), new String[]{"buy"}).child((CommandCallable)CommandSpec.builder().permission("lottery.addpot").executor((CommandExecutor)new AddPotCommand(this.configManager, this.PLUGIN_CAUSE)).arguments(GenericArguments.integer((Text)StringsKt.toText("amount"))).build(), new String[]{"addpot"}).child((CommandCallable)CommandSpec.builder().permission("lottery.draw").executor((CommandExecutor)new PlayerExecutedCommand(this){
            final /* synthetic */ Lottery this$0;

            @NotNull
            public CommandResult executedByPlayer(@NotNull Player player, @NotNull CommandContext args) {
                Intrinsics.checkParameterIsNotNull(player, "player");
                Intrinsics.checkParameterIsNotNull(args, "args");
                this.this$0.draw(this.this$0.getConfigManager().get());
                CommandResult commandResult = CommandResult.success();
                Intrinsics.checkExpressionValueIsNotNull(commandResult, "CommandResult.success()");
                return commandResult;
            }
            {
                this.this$0 = $outer;
            }
        }).build(), new String[]{"draw"}).child((CommandCallable)CommandSpec.builder().executor((CommandExecutor)new InfoCommand(this.configManager, new Function0<Duration>(this){
            final /* synthetic */ Lottery this$0;

            @NotNull
            public final Duration invoke() {
                return this.this$0.getDurationUntilDraw();
            }
            {
                this.this$0 = lottery;
                super(0);
            }
        })).build(), new String[]{"info"}).build(), new String[]{"lottery", "lot"});
        Config config = this.configManager.get();
        this.setDurationUntilDraw(config);
        this.resetTasks(config);
        this.logger.info("Lottery loaded: 2.0.2");
    }

    @Listener
    public final void onReload(@NotNull GameReloadEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        this.configManager.generate();
        this.resetTasks(this.configManager.get());
        this.logger.info("Lottery reloaded!");
    }

    /*
     * WARNING - void declaration
     */
    public final void draw(@NotNull Config config) {
        UUID winner;
        void $receiver$iv$iv;
        Map<UUID, Integer> $receiver$iv;
        Intrinsics.checkParameterIsNotNull(config, "config");
        Map<UUID, Integer> map = $receiver$iv = config.getInternalData().getBoughtTickets();
        Collection destination$iv$iv = new ArrayList($receiver$iv.size());
        void var5_5 = $receiver$iv$iv;
        Iterator iterator2 = var5_5.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            List list = Collections.nCopies(((Number)it.getValue()).intValue(), it.getKey());
            collection.add(list);
        }
        List ticketBuyers = CollectionsKt.flatten((List)destination$iv$iv);
        if (ticketBuyers.isEmpty()) {
            LotteryKt.broadcast(StringsKt.gray("No tickets were bought, the draw is postponed!"));
            return;
        }
        Collections.shuffle(ticketBuyers);
        UUID uUID = winner = (UUID)CollectionsKt.first(ticketBuyers);
        Intrinsics.checkExpressionValueIsNotNull(uUID, "winner");
        this.playerWon(config, uUID);
        DrawEvent drawEvent = new DrawEvent(winner, config.calculatePot(), this.PLUGIN_CAUSE);
        Sponge.getEventManager().post((Event)drawEvent);
        this.resetPot(config);
    }

    public final void playerWon(@NotNull Config config, @NotNull UUID uuid) {
        Text message;
        Intrinsics.checkParameterIsNotNull(config, "config");
        Intrinsics.checkParameterIsNotNull(uuid, "uuid");
        Object object = UuidsKt.getUser(uuid);
        if (object == null || (object = object.getName()) == null) {
            object = "unknown";
        }
        Object playerName = object;
        double pot = config.calculatePot();
        Currency defaultCurrency = LotteryKt.getDefaultCurrency();
        Text text = message = config.getMessages().getDrawMessageBroadcast().apply(MapsKt.mapOf(TuplesKt.to("winnerName", playerName), TuplesKt.to("pot", pot), TuplesKt.to("currencySymbol", defaultCurrency.getSymbol()), TuplesKt.to("currencyName", defaultCurrency.getPluralDisplayName()))).build();
        Intrinsics.checkExpressionValueIsNotNull(text, "message");
        LotteryKt.broadcast(text);
        EconomyService economyService = LotteryKt.getEconomyServiceOrFail();
        ((UniqueAccount)economyService.getOrCreateAccount(uuid).get()).deposit(economyService.getDefaultCurrency(), new BigDecimal(pot), this.PLUGIN_CAUSE);
    }

    public final void resetPot(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull(config, "config");
        Map<UUID, Integer> map = MapsKt.emptyMap();
        int n = 0;
        InternalData newInternalData = config.getInternalData().copy(map, n);
        Config newConfig = Config.copy$default(config, null, 0, 0, 0, 0, null, newInternalData, null, 191, null);
        this.configManager.save(newConfig);
    }

    @NotNull
    public final Duration getDurationUntilDraw() {
        Temporal temporal = Instant.now();
        Instant instant = this.nextDraw;
        if (instant == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nextDraw");
        }
        Duration duration = Duration.between(temporal, instant);
        Intrinsics.checkExpressionValueIsNotNull(duration, "Duration.between(Instant.now(), nextDraw)");
        return duration;
    }

    public final void setDurationUntilDraw(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull(config, "config");
        Instant instant = Instant.now();
        Intrinsics.checkExpressionValueIsNotNull(instant, "Instant.now()");
        Instant instant2 = Instant.ofEpochSecond(instant.getEpochSecond() + config.getDrawInterval().getSeconds());
        Intrinsics.checkExpressionValueIsNotNull(instant2, "Instant.ofEpochSecond(In\u2026fig.drawInterval.seconds)");
        this.nextDraw = instant2;
    }

    public final void resetTasks(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull(config, "config");
        Set set = Sponge.getScheduler().getScheduledTasks((Object)this);
        Intrinsics.checkExpressionValueIsNotNull(set, "Sponge.getScheduler().getScheduledTasks(this)");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            Task it = (Task)element$iv;
            it.cancel();
        }
        Task.builder().interval(config.getDrawInterval().getSeconds(), TimeUnit.SECONDS).execute(new Runnable(this){
            final /* synthetic */ Lottery this$0;

            public final void run() {
                Config currentConfig = this.this$0.getConfigManager().get();
                this.this$0.draw(currentConfig);
                this.this$0.setDurationUntilDraw(currentConfig);
            }
            {
                this.this$0 = lottery;
            }
        }).submit((Object)this);
        Task.builder().delay(5L, TimeUnit.SECONDS).interval(config.getBroadcasts().getTimedBroadcastInterval().getSeconds(), TimeUnit.SECONDS).execute(new Runnable(this){
            final /* synthetic */ Lottery this$0;

            public final void run() {
                Text broadcastText;
                Config currentConfig = this.this$0.getConfigManager().get();
                Currency currency = LotteryKt.getDefaultCurrency();
                Text text = broadcastText = currentConfig.getMessages().getBroadcast().apply(MapsKt.mapOf(TuplesKt.to("currencySymbol", currency.getSymbol()), TuplesKt.to("currencyName", currency.getName()), TuplesKt.to("pot", currentConfig.calculatePot()))).build();
                Intrinsics.checkExpressionValueIsNotNull(text, "broadcastText");
                LotteryKt.broadcast(text);
            }
            {
                this.this$0 = lottery;
            }
        }).submit((Object)this);
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @Inject
    public Lottery(@NotNull Logger logger, @DefaultConfig(sharedRoot=true) @NotNull ConfigurationLoader<CommentedConfigurationNode> configLoader, @NotNull PluginContainer pluginContainer, @NotNull Metrics bstats) {
        Intrinsics.checkParameterIsNotNull(logger, "logger");
        Intrinsics.checkParameterIsNotNull(configLoader, "configLoader");
        Intrinsics.checkParameterIsNotNull(pluginContainer, "pluginContainer");
        Intrinsics.checkParameterIsNotNull(bstats, "bstats");
        this.logger = logger;
        this.bstats = bstats;
        this.configManager = new ConfigManager(configLoader, Config.class, false, true, true, true, false, null, 196, null);
        Cause cause = Cause.builder().append((Object)pluginContainer).build(EventContext.empty());
        Intrinsics.checkExpressionValueIsNotNull(cause, "Cause.builder().append(p\u2026ild(EventContext.empty())");
        this.PLUGIN_CAUSE = cause;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/randombyte/lottery/Lottery$Companion;", "", "()V", "AUTHOR", "", "ID", "NAME", "ROOT_PERMISSION", "VERSION", "lottery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

