/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.lib.multiblock.tilemodule;

import com.valkyrieofnight.vlib.multiblock_legacy.api.tile.IMBTileCont;
import com.valkyrieofnight.vlib.multiblock_legacy.api.tile.IMBTileSlave;
import com.valkyrieofnight.vliblegacy.lib.sys.tile.plugin.ITlePlugin;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;

public class StructureFormer
implements ITlePlugin<StructureFormer> {
    protected int mbDirection = -1;
    private boolean isFormed = false;
    private int ticker = 0;
    private BlockPos formedPosition;
    private TileEntity tile;
    private IMBTileCont controller;

    public StructureFormer(TileEntity tile) {
        this.tile = tile;
        if (!(tile instanceof IMBTileCont)) {
            throw new IllegalArgumentException("Tile must be of type IControllerTile");
        }
        this.controller = (IMBTileCont)tile;
    }

    @Override
    public void loadTileData(NBTTagCompound nbt, boolean fromItem) {
        if (fromItem) {
            return;
        }
        if (nbt.func_74764_b("isFormed")) {
            this.isFormed = nbt.func_74767_n("isFormed");
            this.mbDirection = nbt.func_74762_e("mbdir");
            this.formedPosition = new BlockPos(nbt.func_74762_e("formed_x"), nbt.func_74762_e("formed_y"), nbt.func_74762_e("formed_z"));
        }
    }

    @Override
    public NBTTagCompound saveTileData(NBTTagCompound nbt, boolean toItem) {
        if (toItem) {
            return nbt;
        }
        if (this.isFormed) {
            nbt.func_74757_a("isFormed", this.isFormed);
            nbt.func_74768_a("mbdir", this.mbDirection);
            nbt.func_74768_a("formed_x", this.formedPosition.func_177958_n());
            nbt.func_74768_a("formed_y", this.formedPosition.func_177956_o());
            nbt.func_74768_a("formed_z", this.formedPosition.func_177952_p());
        }
        return nbt;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return false;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return null;
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void onChunkUnload() {
    }

    @Override
    public void update() {
        if (!this.tile.func_145831_w().field_72995_K) {
            ++this.ticker;
            if (this.ticker % 60 == 0) {
                if (!this.tile.func_174877_v().equals((Object)this.formedPosition)) {
                    this.deformMultiblock();
                }
                if (!this.isFormed) {
                    this.mbDirection = this.controller.getStructure().verifyLayout(this.tile.func_145831_w(), this.tile.func_174877_v());
                    if (this.mbDirection != -1) {
                        this.controller.getStructure().initStructure(this.tile.func_145831_w(), this.tile.func_174877_v(), this.controller.getStructure().getSlavesLayout(this.tile.func_145831_w(), this.tile.func_174877_v(), EnumFacing.func_82600_a((int)this.mbDirection)));
                        this.isFormed = true;
                        this.formedPosition = this.tile.func_174877_v();
                    }
                }
                if (this.ticker > 6000) {
                    this.ticker = 0;
                }
            }
        }
    }

    public void deformMultiblock() {
        for (BlockPos p : this.controller.getStructure().getSlavesLayout(this.tile.func_145831_w(), this.tile.func_174877_v(), EnumFacing.func_82600_a((int)this.mbDirection))) {
            TileEntity te = this.tile.func_145831_w().func_175625_s(p);
            if (te == null || !(te instanceof IMBTileSlave)) continue;
            ((IMBTileSlave)te).removeController();
        }
        this.isFormed = false;
    }

    public boolean isFormed() {
        return this.isFormed;
    }

    public int getMBDirection() {
        return this.mbDirection;
    }

    public EnumFacing getMBDirectionE() {
        return EnumFacing.func_82600_a((int)this.mbDirection);
    }

    public void packetUpdateFormer(boolean formed) {
        this.isFormed = formed;
    }

    @Override
    public void onLoad() {
    }
}

