/*
 * Decompiled with CFR 0.152.
 */
package org.dave.ocsensors.integration.entity;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.village.MerchantRecipe;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.dave.ocsensors.integration.AbstractIntegration;
import org.dave.ocsensors.integration.Integrate;
import org.dave.ocsensors.integration.ScanDataList;
import org.dave.ocsensors.utility.ObfuscationReflectionHelperEx;

@Integrate(name="entity_villager")
public class EntityVillagerIntegration
extends AbstractIntegration {
    private static Field villagerCareerId = ObfuscationReflectionHelperEx.findField(EntityVillager.class, "careerId");
    private static Field villagerBuyingList = ObfuscationReflectionHelperEx.findField(EntityVillager.class, "buyingList");

    @Override
    public boolean worksWith(Entity entity) {
        return villagerCareerId != null && villagerBuyingList != null && entity instanceof EntityVillager;
    }

    @Override
    public void addScanData(ScanDataList data, Entity entity) {
        List<MerchantRecipe> merchantRecipes;
        super.addScanData(data, entity);
        data.add("type", "villager");
        EntityVillager villager = (EntityVillager)entity;
        HashMap<String, Object> villagerData = new HashMap<String, Object>();
        VillagerRegistry.VillagerProfession profession = villager.getProfessionForge();
        villagerData.put("profession", profession.getRegistryName().toString());
        VillagerRegistry.VillagerCareer career = this.getCareer(villager);
        if (career != null) {
            villagerData.put("career", career.getName());
        }
        if ((merchantRecipes = this.getMerchantRecipes(villager)) != null) {
            villagerData.put("offers", merchantRecipes);
        }
        data.add("villager", villagerData);
    }

    private List<MerchantRecipe> getMerchantRecipes(EntityVillager villager) {
        try {
            return (List)villagerBuyingList.get(villager);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    private VillagerRegistry.VillagerCareer getCareer(EntityVillager villager) {
        try {
            return villager.getProfessionForge().getCareer(((Integer)villagerCareerId.get(villager)).intValue());
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }
}

