/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.gui.GuiEditTileScreen;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.network.XUPacketClientToServer;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.utils.helpers.SideHelper;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class TileScreen
extends TilePower
implements IGuiHandler {
    public static final Pattern illegalPatternControlCode = Pattern.compile("[^0-9A-Za-z]");
    @Nonnull
    public String id = "";

    @Override
    public void onPowerChanged() {
        this.markForUpdate();
    }

    @Override
    public float getPower() {
        return 1.0f;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("image_id", this.id);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.id = compound.func_74779_i("image_id");
    }

    @Override
    public void addToDescriptionPacket(XUPacketBuffer packet) {
        super.addToDescriptionPacket(packet);
        packet.writeString(this.id);
        packet.writeInt(this.frequency);
    }

    @Override
    public void handleDescriptionPacket(XUPacketBuffer packet) {
        super.handleDescriptionPacket(packet);
        this.id = packet.readString();
        this.frequency = packet.readInt();
        this.markForUpdate();
    }

    public boolean canRenderBreaking() {
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return super.shouldRenderInPass(pass);
    }

    public boolean canJoinWith(BlockPos pos) {
        TileEntity tileEntity = this.func_145831_w().func_175625_s(pos);
        if (!(tileEntity instanceof TileScreen)) {
            return false;
        }
        TileScreen te = (TileScreen)tileEntity;
        return this.getBlockState() == te.getBlockState() && this.id.equals(te.id) && this.field_145850_b.field_72995_K && this.frequency == te.frequency;
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            this.openGUI(playerIn);
        }
        return true;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public Object getServerGuiElement(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public Object getClientGuiElement(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new GuiEditTileScreen(this);
    }

    @Override
    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, XUBlock xuBlock) {
        super.onBlockPlacedBy(worldIn, pos, state, placer, stack, xuBlock);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (placer instanceof EntityPlayerMP && ExtraUtils2.proxy.isAltSneaking((EntityPlayer)((EntityPlayerMP)placer))) {
            return;
        }
        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)XUBlockStateCreator.ROTATION_HORIZONTAL);
        TileScreen toCopy = null;
        for (EnumFacing enumFacing : SideHelper.perp_sides[side.ordinal()]) {
            TileScreen otherScreen;
            TileEntity te = worldIn.func_175625_s(pos.func_177972_a(enumFacing));
            if (!(te instanceof TileScreen) || (otherScreen = (TileScreen)te).getBlockState() != state || otherScreen.frequency != this.frequency || StringUtils.func_151246_b((String)otherScreen.id)) continue;
            if (toCopy != null) {
                if (toCopy.id.equals(otherScreen.id)) continue;
                toCopy = null;
                break;
            }
            toCopy = otherScreen;
        }
        if (toCopy != null) {
            this.id = toCopy.id;
            this.markForUpdate();
        }
    }

    @NetworkHandler.XUPacket
    public static class PacketEditScreen
    extends XUPacketClientToServer {
        private String id;
        private BlockPos pos;
        private EntityPlayer player;

        public PacketEditScreen() {
        }

        public PacketEditScreen(BlockPos pos, String id) {
            this.pos = pos;
            this.id = id;
        }

        @Override
        public void writeData() throws Exception {
            this.writeString(this.id);
            this.writeBlockPos(this.pos);
            if (illegalPatternControlCode.matcher(this.id).find()) {
                throw new RuntimeException("Illegal ID");
            }
        }

        @Override
        public void readData(EntityPlayer player) {
            this.player = player;
            this.id = this.readString();
            this.pos = this.readBlockPos();
            if (illegalPatternControlCode.matcher(this.id).find()) {
                throw new RuntimeException("Illegal ID");
            }
        }

        @Override
        public Runnable doStuffServer() {
            return new Runnable(){

                @Override
                public void run() {
                    BlockPos next;
                    EnumFacing[] perp_sides;
                    if ("error".equals(id)) {
                        throw new RuntimeException("Artificial error");
                    }
                    World worldObj1 = ((PacketEditScreen)this).player.field_70170_p;
                    TileEntity t = worldObj1.func_175625_s(pos);
                    if (!(t instanceof TileScreen)) {
                        return;
                    }
                    TileScreen screen = (TileScreen)t;
                    if (!screen.isValidPlayer(player)) {
                        return;
                    }
                    String oldID = screen.id;
                    screen.id = id;
                    screen.func_70296_d();
                    screen.markForUpdate();
                    ArrayList<TileScreen> screens = new ArrayList<TileScreen>();
                    LinkedHashSet<BlockPos> checkedPositions = new LinkedHashSet<BlockPos>();
                    LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
                    checkedPositions.add(pos);
                    for (EnumFacing perp_side : perp_sides = SideHelper.perp_sides[((EnumFacing)screen.getBlockState().func_177229_b((IProperty)XUBlockStateCreator.ROTATION_HORIZONTAL)).ordinal()]) {
                        toCheck.add(pos.func_177972_a(perp_side));
                    }
                    while ((next = (BlockPos)toCheck.poll()) != null && checkedPositions.size() < 100) {
                        checkedPositions.add(next);
                        TileEntity tileEntity = worldObj1.func_175625_s(next);
                        if (!(tileEntity instanceof TileScreen)) continue;
                        TileScreen te = (TileScreen)tileEntity;
                        if (te.frequency != screen.frequency || te.getBlockState() != screen.getBlockState() || !oldID.equals(te.id)) continue;
                        screens.add(te);
                        for (EnumFacing side : perp_sides) {
                            BlockPos offset = next.func_177972_a(side);
                            if (checkedPositions.contains(offset)) continue;
                            toCheck.offer(offset);
                        }
                    }
                    for (TileScreen tileScreen : screens) {
                        tileScreen.id = id;
                        tileScreen.func_70296_d();
                        tileScreen.markForUpdate();
                    }
                }
            };
        }
    }
}

