/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStackValidated;
import cofh.core.inventory.OreValidator;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.util.parsers.ConstantParser;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class FurnaceManager {
    private static Map<ComparableItemStackValidated, FurnaceRecipe> recipeMap = new Object2ObjectOpenHashMap();
    private static Map<ComparableItemStackValidated, FurnaceRecipe> recipeMapPyrolysis = new Object2ObjectOpenHashMap();
    private static Set<ComparableItemStackValidated> foodSet = new ObjectOpenHashSet();
    private static OreValidator oreValidator = new OreValidator();
    public static final int DEFAULT_ENERGY = 2000;

    public static FurnaceRecipe getRecipe(ItemStack input, boolean pyrolysis) {
        if (input.func_190926_b()) {
            return null;
        }
        ComparableItemStackValidated query = FurnaceManager.convertInput(input);
        if (pyrolysis) {
            FurnaceRecipe recipe = recipeMapPyrolysis.get(query);
            if (recipe == null) {
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMapPyrolysis.get(query);
            }
            return recipe;
        }
        FurnaceRecipe recipe = recipeMap.get(query);
        if (recipe == null) {
            query.metadata = Short.MAX_VALUE;
            recipe = recipeMap.get(query);
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack input, boolean pyrolysis) {
        return FurnaceManager.getRecipe(input, pyrolysis) != null;
    }

    public static FurnaceRecipe[] getRecipeList(boolean pyrolysis) {
        if (pyrolysis) {
            return recipeMapPyrolysis.values().toArray(new FurnaceRecipe[0]);
        }
        return recipeMap.values().toArray(new FurnaceRecipe[0]);
    }

    public static void initialize() {
        Map smeltingList = FurnaceRecipes.func_77602_a().func_77599_b();
        for (ItemStack key : smeltingList.keySet()) {
            if (key.func_190926_b() || FurnaceManager.recipeExists(key, false)) continue;
            ItemStack output = (ItemStack)smeltingList.get(key);
            if (ConstantParser.hasOre(ItemHelper.getOreName((ItemStack)output))) {
                output = ItemHelper.cloneStack((ItemStack)ConstantParser.getOre(ItemHelper.getOreName((ItemStack)output)), (int)output.func_190916_E());
            }
            int energy = 2000;
            if (output.func_77973_b() instanceof ItemFood) {
                foodSet.add(FurnaceManager.convertInput(key));
                energy /= 2;
            }
            if (ItemHelper.isDust((ItemStack)key) && ItemHelper.isIngot((ItemStack)output)) {
                FurnaceManager.addRecipe(energy * 3 / 4, key, output);
                continue;
            }
            if (ItemHelper.getItemDamage((ItemStack)key) == Short.MAX_VALUE) {
                ItemStack testKey = ItemHelper.cloneStack((ItemStack)key);
                testKey.func_77964_b(0);
                if (ItemHelper.hasOreName((ItemStack)testKey) && oreValidator.validate(ItemHelper.getOreName((ItemStack)testKey))) {
                    FurnaceManager.addRecipe(energy, testKey, output);
                    continue;
                }
            }
            FurnaceManager.addRecipe(energy, key, output);
        }
    }

    public static void refresh() {
        FurnaceRecipe tempRecipe;
        Object2ObjectOpenHashMap tempMap = new Object2ObjectOpenHashMap(recipeMap.size());
        Object2ObjectOpenHashMap tempMapPyrolysis = new Object2ObjectOpenHashMap(recipeMapPyrolysis.size());
        ObjectOpenHashSet tempFood = new ObjectOpenHashSet();
        for (Map.Entry<ComparableItemStackValidated, FurnaceRecipe> entry : recipeMap.entrySet()) {
            tempRecipe = entry.getValue();
            tempMap.put(FurnaceManager.convertInput(tempRecipe.input), tempRecipe);
        }
        for (Map.Entry<ComparableItemStackValidated, FurnaceRecipe> entry : recipeMapPyrolysis.entrySet()) {
            tempRecipe = entry.getValue();
            tempMapPyrolysis.put(FurnaceManager.convertInput(tempRecipe.input), tempRecipe);
        }
        for (ComparableItemStackValidated comparableItemStackValidated : foodSet) {
            ComparableItemStackValidated food = FurnaceManager.convertInput(new ItemStack(comparableItemStackValidated.item, comparableItemStackValidated.stackSize, comparableItemStackValidated.metadata));
            tempFood.add(food);
        }
        recipeMap.clear();
        recipeMap = tempMap;
        recipeMapPyrolysis.clear();
        recipeMapPyrolysis = tempMapPyrolysis;
        foodSet.clear();
        foodSet = tempFood;
    }

    public static FurnaceRecipe addRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b() || energy <= 0 || FurnaceManager.recipeExists(input, false)) {
            return null;
        }
        FurnaceRecipe recipe = new FurnaceRecipe(input, output, energy);
        recipeMap.put(FurnaceManager.convertInput(input), recipe);
        return recipe;
    }

    public static FurnaceRecipe addRecipePyrolysis(int energy, ItemStack input, ItemStack output, int creosote) {
        if (input.func_190926_b() || output.func_190926_b() || energy <= 0 || FurnaceManager.recipeExists(input, true)) {
            return null;
        }
        FurnaceRecipe recipe = new FurnaceRecipe(input, output, energy, creosote);
        recipeMapPyrolysis.put(FurnaceManager.convertInput(input), recipe);
        return recipe;
    }

    public static FurnaceRecipe removeRecipe(ItemStack input) {
        return recipeMap.remove(FurnaceManager.convertInput(input));
    }

    public static FurnaceRecipe removeRecipePyrolysis(ItemStack input) {
        return recipeMapPyrolysis.remove(FurnaceManager.convertInput(input));
    }

    public static ComparableItemStackValidated convertInput(ItemStack stack) {
        return new ComparableItemStackValidated(stack, oreValidator);
    }

    public static boolean isFood(ItemStack input) {
        if (input.func_190926_b()) {
            return false;
        }
        ComparableItemStackValidated query = FurnaceManager.convertInput(input);
        if (foodSet.contains(query)) {
            return true;
        }
        query.metadata = Short.MAX_VALUE;
        return foodSet.contains(query);
    }

    public static boolean isOre(ItemStack stack) {
        return ItemHelper.isOre((ItemStack)stack) || ItemHelper.isCluster((ItemStack)stack);
    }

    static {
        oreValidator.addPrefix("ore");
        oreValidator.addPrefix("dust");
        oreValidator.addPrefix("log");
    }

    public static class FurnaceRecipe {
        final ItemStack input;
        final ItemStack output;
        final int energy;
        final int creosote;

        FurnaceRecipe(ItemStack input, ItemStack output, int energy) {
            this(input, output, energy, 0);
        }

        FurnaceRecipe(ItemStack input, ItemStack output, int energy, int creosote) {
            this.input = input;
            this.output = output;
            this.energy = energy;
            this.creosote = creosote;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public int getEnergy() {
            return this.energy;
        }

        public int getCreosote() {
            return this.creosote;
        }
    }
}

