/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy.dimension.world.worldengine;

import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_WorldProviderSpace;
import asmodeuscore.core.utils.Utils;
import asmodeuscore.core.utils.worldengine.WE_Biome;
import asmodeuscore.core.utils.worldengine.WE_ChunkProvider;
import asmodeuscore.core.utils.worldengine.additions.WE_CreateChunkGen;
import asmodeuscore.core.utils.worldengine.additions.WE_CreateChunkGen_InXYZ;
import asmodeuscore.core.utils.worldengine.additions.WE_CreateChunkGen_InXZ;
import asmodeuscore.core.utils.worldengine.additions.WE_GeneratorData;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_CaveGen;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_LakeGen;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_OreGen;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_RavineGen;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_TerrainGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.world.gen.EnumCraterSize;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.fml.common.FMLLog;

public class WE_ChunkProviderSpace
extends WE_ChunkProvider {
    private final Gradient noiseGen5;
    public List<MapGenBaseMeta> worldGenerators = new ArrayList<MapGenBaseMeta>();
    private BiomeDecoratorSpace decorator;
    public int CRATER_PROB = 0;

    public WE_ChunkProviderSpace(WE_WorldProviderSpace wp) {
        this.rand = new Random(wp.getSeed());
        this.worldObj = wp.field_76579_a;
        this.wp = wp;
        this.createChunkGen_List.add(new WE_TerrainGenerator());
        this.createChunkGen_List.add(new WE_CaveGen());
        this.createChunkGen_List.add(new WE_RavineGen());
        WE_OreGen standardOres = new WE_OreGen();
        standardOres.add(Blocks.field_150352_o.func_176223_P(), Blocks.field_150348_b.func_176223_P(), 4, 0, 32, 16);
        standardOres.add(Blocks.field_150366_p.func_176223_P(), Blocks.field_150348_b.func_176223_P(), 6, 0, 64, 72);
        standardOres.add(Blocks.field_150365_q.func_176223_P(), Blocks.field_150348_b.func_176223_P(), 6, 32, 128, 56);
        standardOres.add(Blocks.field_150369_x.func_176223_P(), Blocks.field_150348_b.func_176223_P(), 4, 0, 16, 16);
        standardOres.add(Blocks.field_150482_ag.func_176223_P(), Blocks.field_150348_b.func_176223_P(), 3, 0, 16, 16);
        standardOres.add(Blocks.field_150412_bA.func_176223_P(), Blocks.field_150348_b.func_176223_P(), 2, 0, 16, 24);
        this.decorateChunkGen_List.add(standardOres);
        WE_LakeGen lavaLakes = new WE_LakeGen();
        lavaLakes.lakeBlock = Blocks.field_150353_l.func_176223_P();
        lavaLakes.fGen = false;
        lavaLakes.maxY = 32;
        this.decorateChunkGen_List.add(lavaLakes);
        this.noiseGen5 = new Gradient(this.rand.nextLong(), 1, 0.25f);
        wp.genSettings(this);
        WE_Biome.setChunkProvider(this);
    }

    @Override
    public Chunk func_185932_a(int chunkX, int chunkZ) {
        ChunkPrimer primer = new ChunkPrimer();
        this.rand.setSeed((long)chunkX * 6824L * this.rand.nextLong() + (long)chunkZ * 146346L * this.rand.nextLong() + 315723968L);
        try {
            int z;
            int x;
            this.noiseGen5.setFrequency(0.01f);
            long chunk_X = (long)chunkX * 16L;
            long chunk_Z = (long)chunkZ * 16L;
            WE_Biome.setChunkProvider(this);
            WE_Biome[][] chunkBiomes = new WE_Biome[16][16];
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    chunkBiomes[x][z] = WE_Biome.getBiomeAt(this, chunk_X + (long)x, chunk_Z + (long)z);
                }
            }
            for (int i = 0; i < this.createChunkGen_List.size(); ++i) {
                ((WE_CreateChunkGen)this.createChunkGen_List.get(i)).gen(new WE_GeneratorData(this, primer, chunk_X, chunk_Z, chunkBiomes, 0, 0, 0));
            }
            if (this.CRATER_PROB > 0) {
                this.createCraters(chunkX, chunkZ, primer);
            }
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    int i;
                    for (i = 0; i < this.createChunkGen_InXZ_List.size(); ++i) {
                        ((WE_CreateChunkGen_InXZ)this.createChunkGen_InXZ_List.get(i)).gen(new WE_GeneratorData(this, primer, chunk_X, chunk_Z, chunkBiomes, x, 0, z));
                    }
                    for (i = 0; i < chunkBiomes[x][z].createChunkGen_InXZ_List.size(); ++i) {
                        chunkBiomes[x][z].createChunkGen_InXZ_List.get(i).gen(new WE_GeneratorData(this, primer, chunk_X, chunk_Z, chunkBiomes, x, 0, z));
                    }
                    for (int y = 255; y >= 0; --y) {
                        int i2;
                        for (i2 = 0; i2 < this.createChunkGen_InXYZ_List.size(); ++i2) {
                            ((WE_CreateChunkGen_InXYZ)this.createChunkGen_InXYZ_List.get(i2)).gen(new WE_GeneratorData(this, primer, chunk_X, chunk_Z, chunkBiomes, x, y, z));
                        }
                        for (i2 = 0; i2 < chunkBiomes[x][z].createChunkGen_InXYZ_List.size(); ++i2) {
                            chunkBiomes[x][z].createChunkGen_InXYZ_List.get(i2).gen(new WE_GeneratorData(this, primer, chunk_X, chunk_Z, chunkBiomes, x, y, z));
                        }
                    }
                }
            }
            this.wp.onChunkProvider(chunkX, chunkZ, primer);
            for (MapGenBaseMeta generator : this.worldGenerators) {
                generator.generate(this.worldObj, chunkX, chunkZ, primer);
            }
        }
        catch (Exception e) {
            FMLLog.warning((String)("Error caught in planetary worldgen at coords " + chunkX + "," + chunkZ + "."), (Object[])new Object[0]);
            e.printStackTrace();
        }
        Chunk chunk = new Chunk(this.worldObj, primer, chunkX, chunkZ);
        byte[] arraybiome = new byte[256];
        Arrays.fill(arraybiome, (byte)Biome.func_185362_a((Biome)Utils.WE_Biome));
        chunk.func_76616_a(arraybiome);
        chunk.func_76603_b();
        return chunk;
    }

    @Override
    public void func_185931_b(int chunkX, int chunkZ) {
        super.func_185931_b(chunkX, chunkZ);
    }

    @Override
    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return super.func_177458_a(creatureType, pos);
    }

    @Override
    public void func_180514_a(Chunk chunkIn, int x, int z) {
        this.wp.recreateStructures(chunkIn, x, z);
    }

    @Override
    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    @Override
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    @Override
    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    public void createCraters(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.noiseGen5.setFrequency(0.015f);
        for (int cx = chunkX - 2; cx <= chunkX + 2; ++cx) {
            for (int cz = chunkZ - 2; cz <= chunkZ + 2; ++cz) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        if (!(Math.abs(this.randFromPoint(cx * 16 + x, (cz * 16 + z) * 1000)) < (double)(this.noiseGen5.getNoise((float)(cx * 16 + x), (float)(cz * 16 + z)) / (float)this.CRATER_PROB))) continue;
                        Random random = new Random(cx * 16 + x + (cz * 16 + z) * 5000);
                        EnumCraterSize cSize = EnumCraterSize.sizeArray[random.nextInt(EnumCraterSize.sizeArray.length)];
                        int size = random.nextInt(cSize.MAX_SIZE - cSize.MIN_SIZE) + cSize.MIN_SIZE + 15;
                        this.makeCrater(cx * 16 + x, cz * 16 + z, chunkX * 16, chunkZ * 16, size, primer);
                    }
                }
            }
        }
    }

    public void makeCrater(int craterX, int craterZ, int chunkX, int chunkZ, int size, ChunkPrimer primer) {
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                double xDev = craterX - (chunkX + x);
                double zDev = craterZ - (chunkZ + z);
                if (!(xDev * xDev + zDev * zDev < (double)(size * size))) continue;
                double sqrtY = (xDev /= (double)size) * xDev + (zDev /= (double)size) * zDev;
                double yDev = sqrtY * sqrtY * 6.0;
                yDev = 5.0 - yDev;
                int helper = 0;
                for (int y = 180; y > 50; --y) {
                    if (!primer.func_177856_a(x, y, z).func_185904_a().func_76224_d() && Blocks.field_150350_a != primer.func_177856_a(x, y, z).func_177230_c() && (double)helper <= yDev) {
                        primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
                        ++helper;
                    }
                    if ((double)helper > yDev) continue block1;
                }
            }
        }
    }

    private double randFromPoint(int x, int z) {
        int n = x + z * 57;
        n = n << 13 ^ n;
        return 1.0 - (double)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.073741824E9;
    }
}

