/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib;

import icbm.classic.ICBMClassic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;

public class LanguageUtility {
    public static int toolTipLineLength = 30;

    public static String getLocal(String key) {
        if (key == null || key.isEmpty()) {
            if (ICBMClassic.runningAsDev) {
                ICBMClassic.logger().error("LanguageUtility.getLocal(" + key + ") - invalid key", (Throwable)new RuntimeException());
            }
            return "error.key.empty";
        }
        String translation = I18n.func_74838_a((String)key);
        if (translation == null || translation.isEmpty()) {
            if (ICBMClassic.runningAsDev) {
                ICBMClassic.logger().error("LanguageUtility.getLocal(" + key + ") - no translation", (Throwable)new RuntimeException());
            }
            return key;
        }
        return translation;
    }

    public static String getLocalName(String key) {
        String translation;
        if (key == null || key.isEmpty()) {
            if (ICBMClassic.runningAsDev) {
                ICBMClassic.logger().error("LanguageUtility.getLocalName(" + key + ")", (Throwable)new RuntimeException());
            }
            return "error.key.empty";
        }
        if (!key.endsWith(".name")) {
            key = key + ".name";
        }
        if ((translation = I18n.func_74838_a((String)key)) == null || translation.isEmpty()) {
            if (ICBMClassic.runningAsDev) {
                ICBMClassic.logger().error("LanguageUtility.getLocal(" + key + ") - no translation", (Throwable)new RuntimeException());
            }
            return key;
        }
        return translation;
    }

    public static Integer getLangSetting(String key, int backup) {
        block3: {
            String result = LanguageUtility.getLocal(key);
            if (result != null && !result.isEmpty()) {
                try {
                    return Integer.parseInt(key);
                }
                catch (NumberFormatException e) {
                    if (!ICBMClassic.runningAsDev) break block3;
                    ICBMClassic.logger().error("LanguageUtility.getLangSetting(" + key + ")", (Throwable)e);
                }
            }
        }
        return backup;
    }

    public static ITextComponent getLocalChat(String key) {
        return new TextComponentTranslation(key, new Object[0]);
    }

    public static void addChatToPlayer(EntityPlayer player, String key) {
        if (player != null) {
            player.func_145747_a(LanguageUtility.getLocalChat(key));
        } else if (ICBMClassic.runningAsDev) {
            ICBMClassic.logger().error("LanguageUtility.addChatToPlayer(Null Player, " + key + ")", (Throwable)new RuntimeException());
        }
    }

    public static List<String> splitStringPerWord(String string) {
        return Arrays.asList(LanguageUtility.toWordArray(string));
    }

    public static String[] toWordArray(String string) {
        return string.trim().split("\\W+");
    }

    public static List<String> splitByLine(String string) {
        return LanguageUtility.splitByLine(string, toolTipLineLength);
    }

    public static List<String> splitByLine(String string, int charsPerLine) {
        String[] words = string.split(" ");
        ArrayList<String> lines = new ArrayList<String>();
        String line = "";
        for (String word : words) {
            if (word.length() + line.length() <= charsPerLine) {
                line = line + word + " ";
                continue;
            }
            lines.add(line.trim());
            line = word + " ";
        }
        lines.add(line.trim());
        return lines;
    }

    public static String capitalizeFirst(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
    }

    public static String decapitalizeFirst(String str) {
        return str.substring(0, 1).toLowerCase() + str.substring(1, str.length());
    }
}

