/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.traits;

import c4.conarm.common.armor.utils.ArmorHelper;
import c4.conarm.lib.traits.AbstractArmorTrait;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class TraitInvigorating
extends AbstractArmorTrait {
    protected static final UUID HEALTH_MODIFIER = UUID.fromString("cc2c4cca-6d0c-4468-bca3-7994834be6cc");
    private static final double HEALTH_PER_LEVEL = 4.0;

    public TraitInvigorating() {
        super("invigorating", TextFormatting.LIGHT_PURPLE);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END && evt.side == Side.SERVER) {
            EntityPlayer player = evt.player;
            IAttributeInstance healthAtt = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
            AttributeModifier modifier = healthAtt.func_111127_a(HEALTH_MODIFIER);
            double oldMaxHealth = healthAtt.func_111126_e();
            double level = ArmorHelper.getArmorAbilityLevel(player, this.identifier);
            if (modifier != null) {
                healthAtt.func_111124_b(modifier);
            }
            if (level > 0.0) {
                healthAtt.func_111121_a(new AttributeModifier(HEALTH_MODIFIER, "Invigorating trait modifier", 4.0 * level, 0));
            }
            if (oldMaxHealth > healthAtt.func_111126_e() && player.func_110143_aJ() > player.func_110138_aP()) {
                player.func_70606_j(player.func_110138_aP());
            }
        }
    }
}

