/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cacheddata.type;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.luckperms.api.metastacking.MetaStackDefinition;
import net.luckperms.api.metastacking.MetaStackElement;
import net.luckperms.api.node.ChatMetaType;
import net.luckperms.api.node.types.ChatMetaNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MetaStackAccumulator {
    private final MetaStackDefinition definition;
    private final List<Entry> entries;

    public MetaStackAccumulator(MetaStackDefinition definition, ChatMetaType targetType) {
        this.definition = definition;
        List<MetaStackElement> elements = definition.getElements();
        this.entries = new ArrayList<Entry>(elements.size());
        for (MetaStackElement element : elements) {
            this.entries.add(new Entry(element, targetType));
        }
    }

    public void offer(ChatMetaNode<?, ?> node) {
        for (Entry entry : this.entries) {
            entry.offer(node);
        }
    }

    public String toFormattedString() {
        LinkedList<String> elements = new LinkedList<String>();
        for (Entry entry : this.entries) {
            ChatMetaNode<?, ?> node = entry.getNode();
            if (node == null) continue;
            elements.add(node.getMetaValue());
        }
        if (elements.isEmpty()) {
            return null;
        }
        this.definition.getDuplicateRemovalFunction().processDuplicates(elements);
        Iterator it = elements.iterator();
        if (!it.hasNext()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.definition.getStartSpacer());
        sb.append((String)it.next());
        while (it.hasNext()) {
            sb.append(this.definition.getMiddleSpacer());
            sb.append((String)it.next());
        }
        sb.append(this.definition.getEndSpacer());
        return sb.toString();
    }

    private static final class Entry {
        private final MetaStackElement element;
        private final ChatMetaType type;
        private @Nullable ChatMetaNode<?, ?> current = null;

        Entry(MetaStackElement element, ChatMetaType type) {
            this.element = element;
            this.type = type;
        }

        public ChatMetaNode<?, ?> getNode() {
            return this.current;
        }

        public boolean offer(ChatMetaNode<?, ?> node) {
            if (this.element.shouldAccumulate(this.type, node, this.current)) {
                this.current = node;
                return true;
            }
            return false;
        }
    }
}

