/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command.abstraction;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.Argument;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.lib.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Command<T> {
    private final @NonNull CommandSpec spec;
    private final @NonNull String name;
    private final @Nullable CommandPermission permission;
    private final @NonNull Predicate<Integer> argumentCheck;

    public Command(@NonNull CommandSpec spec, @NonNull String name, @Nullable CommandPermission permission, @NonNull Predicate<Integer> argumentCheck) {
        this.spec = spec;
        this.name = name;
        this.permission = permission;
        this.argumentCheck = argumentCheck;
    }

    public @NonNull CommandSpec getSpec() {
        return this.spec;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull Optional<CommandPermission> getPermission() {
        return Optional.ofNullable(this.permission);
    }

    public @NonNull Predicate<Integer> getArgumentCheck() {
        return this.argumentCheck;
    }

    public Component getDescription() {
        return this.getSpec().description();
    }

    public String getUsage() {
        String usage = this.getSpec().usage();
        return usage == null ? "" : usage;
    }

    public Optional<List<Argument>> getArgs() {
        return Optional.ofNullable(this.getSpec().args());
    }

    public abstract CommandResult execute(LuckPermsPlugin var1, Sender var2, T var3, ArgumentList var4, String var5) throws CommandException;

    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return Collections.emptyList();
    }

    public abstract void sendUsage(Sender var1, String var2);

    public abstract void sendDetailedUsage(Sender var1, String var2);

    public boolean isAuthorized(Sender sender) {
        return this.permission == null || this.permission.isAuthorized(sender);
    }

    public boolean shouldDisplay() {
        return true;
    }
}

