/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import java.util.ArrayList;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.context.contextset.ImmutableContextSetImpl;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.node.matcher.StandardNodeMatchers;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.webeditor.WebEditorRequest;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.node.Node;

public class EditorCommand
extends SingleCommand {
    public EditorCommand() {
        super(CommandSpec.EDITOR, "Editor", CommandPermission.EDITOR, Predicates.notInRange(0, 2));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, ArgumentList args, String label) {
        Type type = Type.ALL;
        String filter = null;
        String arg0 = args.getOrDefault(0, null);
        if (arg0 != null) {
            try {
                type = Type.valueOf(arg0.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                filter = arg0;
            }
            if (filter == null) {
                filter = args.getOrDefault(1, null);
            }
        }
        plugin.getSyncTaskBuffer().requestDirectly();
        ArrayList<PermissionHolder> holders = new ArrayList<PermissionHolder>();
        ArrayList<Track> tracks = new ArrayList<Track>();
        if (type.includingGroups) {
            WebEditorRequest.includeMatchingGroups(holders, Predicates.alwaysTrue(), plugin);
            tracks.addAll(plugin.getTrackManager().getAll().values());
        }
        if (type.includingUsers) {
            ConstraintNodeMatcher<Node> matcher = filter != null ? StandardNodeMatchers.keyStartsWith(filter) : null;
            WebEditorRequest.includeMatchingUsers(holders, matcher, type.includingOffline, plugin);
        }
        if (holders.isEmpty()) {
            Message.EDITOR_NO_MATCH.send(sender);
            return CommandResult.STATE_ERROR;
        }
        holders.removeIf(holder -> ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), holder) || ArgumentPermissions.checkGroup(plugin, sender, holder, (ContextSet)ImmutableContextSetImpl.EMPTY));
        tracks.removeIf(track -> ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), track));
        if (holders.isEmpty() && tracks.isEmpty()) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return CommandResult.NO_PERMISSION;
        }
        Message.EDITOR_START.send(sender);
        return WebEditorRequest.generate(holders, tracks, sender, label, plugin).createSession(plugin, sender);
    }

    private static enum Type {
        ALL(true, true, true),
        ONLINE(true, true, false),
        USERS(true, false, true),
        GROUPS(false, true, true);

        private final boolean includingUsers;
        private final boolean includingGroups;
        private final boolean includingOffline;

        private Type(boolean includingUsers, boolean includingGroups, boolean includingOffline) {
            this.includingUsers = includingUsers;
            this.includingGroups = includingGroups;
            this.includingOffline = includingOffline;
        }
    }
}

