/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.verbose.event;

import me.lucko.luckperms.common.calculator.result.TristateResult;
import me.lucko.luckperms.common.util.gson.JObject;
import me.lucko.luckperms.common.verbose.event.VerboseEvent;
import net.luckperms.api.query.QueryOptions;

public class PermissionCheckEvent
extends VerboseEvent {
    private final Origin origin;
    private final String permission;
    private final TristateResult result;

    public PermissionCheckEvent(Origin origin, String checkTarget, QueryOptions checkQueryOptions, long checkTime, Throwable checkTrace, String checkThread, String permission, TristateResult result) {
        super(checkTarget, checkQueryOptions, checkTime, checkTrace, checkThread);
        this.origin = origin;
        this.permission = permission;
        this.result = result;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public String getPermission() {
        return this.permission;
    }

    public TristateResult getResult() {
        return this.result;
    }

    @Override
    protected void serializeTo(JObject object) {
        object.add("type", "permission");
        object.add("permission", this.permission);
        object.add("result", this.result.result().name().toLowerCase());
        if (this.result.processorClass() != null || this.result.cause() != null) {
            JObject resultInfo = new JObject();
            if (this.result.processorClass() != null) {
                resultInfo.add("processorClass", this.result.processorClass().getName());
            }
            if (this.result.cause() != null) {
                resultInfo.add("cause", this.result.cause());
            }
            object.add("resultInfo", resultInfo);
        }
        object.add("origin", this.origin.name().toLowerCase());
    }

    @Override
    public boolean eval(String variable) {
        return variable.equals("permission") || this.getCheckTarget().equalsIgnoreCase(variable) || this.getPermission().toLowerCase().startsWith(variable.toLowerCase()) || this.getResult().result().name().equalsIgnoreCase(variable);
    }

    public static enum Origin {
        PLATFORM_PERMISSION_CHECK,
        PLATFORM_LOOKUP_CHECK,
        THIRD_PARTY_API,
        LUCKPERMS_API,
        INTERNAL;

    }
}

