/*
 * Decompiled with CFR 0.152.
 */
package forestry.book.data.content;

import forestry.api.book.BookContent;
import forestry.api.gui.IElementGroup;
import forestry.api.gui.IGuiElement;
import forestry.api.gui.IGuiElementFactory;
import forestry.book.BookLoader;
import forestry.book.data.structure.BlockData;
import forestry.book.data.structure.StructureData;
import forestry.book.gui.elements.MultiblockElement;
import forestry.core.utils.Log;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import net.minecraft.client.resources.IResource;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class StructureContent
extends BookContent {
    @Nullable
    private String structureFile = null;
    private transient StructureData structureData;

    @Nullable
    public Class getDataClass() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDeserialization() {
        if (this.structureFile == null || this.structureFile.isEmpty()) {
            return;
        }
        IResource resource = BookLoader.getResource(this.structureFile);
        if (resource == null) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_110527_b(), StandardCharsets.UTF_8));){
            this.structureData = (StructureData)BookLoader.GSON.fromJson((Reader)reader, StructureData.class);
        }
        catch (IOException e) {
            Log.error("Failed to load structure file {}.{}", this.structureFile, e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)resource);
        }
    }

    @Override
    public boolean addElements(IElementGroup page, IGuiElementFactory factory, @Nullable BookContent previous, @Nullable IGuiElement previousElement, int pageHeight) {
        if (this.structureFile == null) {
            return false;
        }
        int offset = 0;
        int structureSizeX = page.getWidth();
        int structureSizeY = 145;
        int[] size = this.structureData.size;
        BlockData[] structure = this.structureData.structure;
        if (size.length == 3 && structure.length > 0) {
            MultiblockElement elementStructure = new MultiblockElement(offset, 0, structureSizeX, structureSizeY, size, structure);
            page.add(elementStructure);
        }
        return true;
    }
}

