/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast.thread;

import com.builtbroken.jlib.lang.StringHelpers;
import icbm.classic.ICBMClassic;
import icbm.classic.config.ConfigDebug;
import icbm.classic.content.blast.Blast;
import icbm.classic.content.blast.thread.BasicResistanceCallBack;
import icbm.classic.content.blast.thread.IThreadCallBack;
import icbm.classic.content.blast.thread.ThreadExplosion;
import icbm.classic.lib.transform.vector.Location;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@Deprecated
public class ThreadLargeExplosion
extends ThreadExplosion {
    public IThreadCallBack callBack;

    public ThreadLargeExplosion(Blast blast, int range, float energy, Entity source, IThreadCallBack callBack) {
        super(blast, range, energy, source);
        this.callBack = callBack;
    }

    public ThreadLargeExplosion(Blast blast, int range, float energy, Entity source) {
        this(blast, range, energy, source, new BasicResistanceCallBack(blast));
    }

    @Override
    public void doRun(World world, Location center) {
        long time = System.nanoTime();
        int steps = (int)Math.ceil(Math.PI / Math.atan(1.0 / (double)this.radius));
        for (int phi_n = 0; phi_n < 2 * steps && !this.kill; ++phi_n) {
            for (int theta_n = 0; theta_n < steps && !this.kill; ++theta_n) {
                double power = this.energy - this.energy * world.field_73012_v.nextFloat() / 2.0f;
                double yaw = Math.PI * 2 / (double)steps * (double)phi_n;
                double pitch = Math.PI / (double)steps * (double)theta_n;
                double dx = Math.sin(pitch) * Math.cos(yaw) * 0.5;
                double dy = Math.cos(pitch) * 0.5;
                double dz = Math.sin(pitch) * Math.sin(yaw) * 0.5;
                double x = center.x();
                double y = center.y();
                double z = center.z();
                BlockPos prevPos = null;
                while (center.distance(x, y, z) <= (double)this.radius && power > 0.0 && !this.kill) {
                    power -= 1.125;
                    BlockPos blockPos = new BlockPos(Math.floor(x), Math.floor(y), Math.floor(z));
                    if (prevPos != blockPos) {
                        if (!this.position.world().func_175667_e(blockPos)) continue;
                        IBlockState state = world.func_180495_p(blockPos);
                        Block block = state.func_177230_c();
                        if (!block.isAir(state, (IBlockAccess)world, blockPos) && state.func_185887_b(world, blockPos) >= 0.0f && (power -= (double)this.callBack.getResistance(world, this.position, blockPos, this.source, block)) > 0.0) {
                            this.blast.addThreadResult(blockPos);
                        }
                    }
                    prevPos = blockPos;
                    x += dx;
                    y += dy;
                    z += dz;
                }
            }
        }
        if (ConfigDebug.DEBUG_THREADS) {
            time = System.nanoTime() - time;
            String timeString = StringHelpers.formatNanoTime(time);
            String msg = "ThreadLargeExplosion#run() -> Completed calculation in [%s] \nBlast: %s\nCompleted: %s\nRadius: %s\nEnergy: %s";
            ICBMClassic.logger().info(String.format(msg, timeString, this.blast, !this.kill, this.radius, Float.valueOf(this.energy)));
        }
    }
}

