/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.entity.missile;

import icbm.classic.api.events.MissileRideEvent;
import icbm.classic.content.entity.missile.EntityMissile;
import icbm.classic.content.entity.missile.MissileFlightType;
import icbm.classic.content.entity.missile.MissileTrackerHandler;
import icbm.classic.lib.radar.RadarMap;
import icbm.classic.lib.radar.RadarRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="icbmclassic")
public class MissileEventHandler {
    @SubscribeEvent
    public static void onEntityMount(EntityMountEvent event) {
        if (event.isDismounting() && event.getEntityBeingMounted() instanceof EntityMissile && event.getEntityMounting() instanceof EntityPlayer) {
            event.setCanceled(MinecraftForge.EVENT_BUS.post((Event)new MissileRideEvent.Stop((EntityMissile)event.getEntityBeingMounted(), (EntityPlayer)event.getEntityMounting())));
        }
    }

    @SubscribeEvent
    public static void chunkUnload(ChunkEvent.Unload event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            Chunk chunk = event.getChunk();
            RadarMap map = RadarRegistry.getRadarMapForWorld(world);
            if (map != null) {
                map.collectEntitiesInChunk(chunk.field_76635_g, chunk.field_76647_h, radarEntity -> {
                    if (radarEntity.entity instanceof EntityMissile) {
                        EntityMissile missile = (EntityMissile)radarEntity.entity;
                        if (!missile.wasSimulated && missile.missileType == MissileFlightType.PAD_LAUNCHER) {
                            MissileTrackerHandler.simulateMissile((EntityMissile)radarEntity.entity);
                        }
                    }
                });
            }
        }
    }
}

