/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.util;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiConsumer;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.transformation.NodePath;
import org.checkerframework.checker.nullness.qual.NonNull;

@Deprecated
public abstract class ConfigurationNodeWalker {
    public static final ConfigurationNodeWalker BREADTH_FIRST = new ConfigurationNodeWalker(){

        @Override
        public <T extends ConfigurationNode> @NonNull Iterator<VisitedNode<T>> walkWithPath(@NonNull T start) {
            return new BreadthFirstIterator<T>(start);
        }
    };
    public static final ConfigurationNodeWalker DEPTH_FIRST_PRE_ORDER = new ConfigurationNodeWalker(){

        @Override
        public <T extends ConfigurationNode> @NonNull Iterator<VisitedNode<T>> walkWithPath(@NonNull T start) {
            return new DepthFirstPreOrderIterator<T>(start);
        }
    };
    public static final ConfigurationNodeWalker DEPTH_FIRST_POST_ORDER = new ConfigurationNodeWalker(){

        @Override
        public <T extends ConfigurationNode> @NonNull Iterator<VisitedNode<T>> walkWithPath(@NonNull T start) {
            return new DepthFirstPostOrderIterator<T>(start);
        }
    };

    public abstract <T extends ConfigurationNode> @NonNull Iterator<VisitedNode<T>> walkWithPath(@NonNull T var1);

    public <T extends ConfigurationNode> @NonNull Iterator<T> walk(@NonNull T start) {
        return Iterators.transform(this.walkWithPath(start), VisitedNode::getNode);
    }

    public <T extends ConfigurationNode> void walk(@NonNull T start, @NonNull BiConsumer<? super NodePath, ? super T> consumer) {
        Iterator<VisitedNode<T>> it = this.walkWithPath(start);
        while (it.hasNext()) {
            VisitedNode<T> next = it.next();
            consumer.accept((NodePath)((NodePath)next.getPath()), (NodePath)((Object)next.getNode()));
        }
    }

    private static Object[] calculatePath(Object[] path, Object childKey) {
        if (path.length == 1 && path[0] == null) {
            return new Object[]{childKey};
        }
        Object[] childPath = Arrays.copyOf(path, path.length + 1);
        childPath[childPath.length - 1] = childKey;
        return childPath;
    }

    private static <T extends ConfigurationNode> Iterator<VisitedNodeImpl<T>> getChildren(VisitedNodeImpl<T> from) {
        T node = from.getNode();
        switch (node.getValueType()) {
            case LIST: {
                Object[] path = from.getRawPath();
                return Iterators.transform(node.getChildrenList().iterator(), child -> {
                    Objects.requireNonNull(child);
                    ConfigurationNode castedChild = child;
                    Object[] childPath = ConfigurationNodeWalker.calculatePath(path, child.getKey());
                    return new VisitedNodeImpl<ConfigurationNode>(childPath, castedChild);
                });
            }
            case MAP: {
                Object[] path = from.getRawPath();
                return Iterators.transform(node.getChildrenMap().entrySet().iterator(), child -> {
                    Objects.requireNonNull(child);
                    ConfigurationNode castedChild = (ConfigurationNode)child.getValue();
                    Object[] childPath = ConfigurationNodeWalker.calculatePath(path, child.getKey());
                    return new VisitedNodeImpl<ConfigurationNode>(childPath, castedChild);
                });
            }
        }
        return Collections.emptyIterator();
    }

    private static final class VisitedNodeImpl<T extends ConfigurationNode>
    implements VisitedNode<T>,
    NodePath {
        private final Object[] path;
        private final T node;

        VisitedNodeImpl(Object[] path, T node) {
            this.path = path;
            this.node = node;
        }

        Object[] getRawPath() {
            return this.path;
        }

        @Override
        public @NonNull T getNode() {
            return this.node;
        }

        @Override
        public @NonNull NodePath getPath() {
            return this;
        }

        @Override
        public Object get(int i) {
            return this.path[i];
        }

        @Override
        public int size() {
            return this.path.length;
        }

        @Override
        public Object[] getArray() {
            return Arrays.copyOf(this.path, this.path.length);
        }

        @Override
        public @NonNull Iterator<Object> iterator() {
            return Iterators.forArray((Object[])this.path);
        }
    }

    public static interface VisitedNode<T extends ConfigurationNode> {
        public @NonNull T getNode();

        public @NonNull NodePath getPath();
    }

    private static final class DepthFirstPostOrderIterator<N extends ConfigurationNode>
    extends AbstractIterator<VisitedNode<N>> {
        private final ArrayDeque<NodeAndChildren> stack = new ArrayDeque();

        DepthFirstPostOrderIterator(N root) {
            this.stack.addLast(new NodeAndChildren(null, Iterators.singletonIterator(new VisitedNodeImpl<N>(root.getPath(), root))));
        }

        protected VisitedNode<N> computeNext() {
            while (!this.stack.isEmpty()) {
                NodeAndChildren tail = this.stack.getLast();
                if (tail.children.hasNext()) {
                    VisitedNodeImpl child = tail.children.next();
                    this.stack.addLast(new NodeAndChildren(child, ConfigurationNodeWalker.getChildren(child)));
                    continue;
                }
                this.stack.removeLast();
                if (tail.node == null) continue;
                return tail.node;
            }
            return (VisitedNode)this.endOfData();
        }

        private final class NodeAndChildren {
            final VisitedNodeImpl<N> node;
            final Iterator<VisitedNodeImpl<N>> children;

            NodeAndChildren(VisitedNodeImpl<N> node, Iterator<VisitedNodeImpl<N>> children) {
                this.node = node;
                this.children = children;
            }
        }
    }

    private static final class DepthFirstPreOrderIterator<N extends ConfigurationNode>
    implements Iterator<VisitedNode<N>> {
        private final Deque<Iterator<VisitedNodeImpl<N>>> stack = new ArrayDeque<Iterator<VisitedNodeImpl<N>>>();

        DepthFirstPreOrderIterator(N root) {
            this.stack.push((Iterator<VisitedNodeImpl<N>>)Iterators.singletonIterator(new VisitedNodeImpl<N>(root.getPath(), root)));
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        @Override
        public VisitedNode<N> next() {
            Iterator childIterator;
            Iterator<VisitedNodeImpl<N>> iterator = this.stack.getLast();
            VisitedNodeImpl<N> result = iterator.next();
            if (!iterator.hasNext()) {
                this.stack.removeLast();
            }
            if ((childIterator = ConfigurationNodeWalker.getChildren(result)).hasNext()) {
                this.stack.addLast(childIterator);
            }
            return result;
        }
    }

    private static final class BreadthFirstIterator<N extends ConfigurationNode>
    implements Iterator<VisitedNode<N>> {
        private final Queue<VisitedNodeImpl<N>> queue = new ArrayDeque<VisitedNodeImpl<N>>();

        BreadthFirstIterator(N root) {
            this.queue.add(new VisitedNodeImpl<N>(root.getPath(), root));
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public VisitedNode<N> next() {
            VisitedNodeImpl<N> current = this.queue.remove();
            Iterators.addAll(this.queue, (Iterator)ConfigurationNodeWalker.getChildren(current));
            return current;
        }
    }
}

