/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.command;

import com.universeguard.region.Region;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;

public class RegionEditExecutor
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (!RegionUtils.hasPendingRegion(src)) {
            if (args.hasAny("name")) {
                Region region = RegionUtils.load((String)args.getOne("name").get());
                if (region != null) {
                    MessageUtils.sendSuccessMessage(src, RegionText.PENDING_REGION_UPDATED.getValue());
                    if (region.isGlobal()) {
                        MessageUtils.sendErrorMessage(src, RegionText.EDITING_GLOBAL.getValue());
                    }
                    MessageUtils.sendSuccessMessage(src, RegionText.EDITING.getValue() + ": " + region.getName());
                    RegionUtils.updatePendingRegion(src, region);
                } else {
                    MessageUtils.sendErrorMessage(src, RegionText.REGION_NOT_FOUND.getValue());
                }
            } else {
                MessageUtils.sendErrorMessage(src, this.getCommandUsage());
            }
        } else {
            MessageUtils.sendErrorMessage(src, RegionText.PENDING_REGION.getValue());
        }
        return CommandResult.empty();
    }

    private String getCommandUsage() {
        return "/rg edit <name>";
    }
}

