/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.storage.file.hocon;

import com.flowpowered.math.vector.Vector3i;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.entities.FactionImpl;
import io.github.aquerr.eaglefactions.common.storage.FactionStorage;
import io.github.aquerr.eaglefactions.common.storage.file.hocon.ConfigurateHelper;
import io.github.aquerr.eaglefactions.common.storage.serializers.ClaimTypeSerializer;
import io.github.aquerr.eaglefactions.common.util.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class HOCONFactionStorage
implements FactionStorage {
    private final Path configDir;
    private final Path factionsDir;
    private final Map<String, ConfigurationLoader<? extends ConfigurationNode>> factionLoaders;

    public HOCONFactionStorage(Path configDir) {
        this.configDir = configDir;
        this.factionsDir = configDir.resolve("factions");
        this.factionLoaders = new HashMap<String, ConfigurationLoader<? extends ConfigurationNode>>();
        if (Files.notExists(this.factionsDir, new LinkOption[0])) {
            try {
                Files.createDirectory(this.factionsDir, new FileAttribute[0]);
                this.preCreate();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (Files.exists(this.configDir.resolve("data"), new LinkOption[0]) && Files.exists(this.configDir.resolve("data").resolve("factions.conf"), new LinkOption[0])) {
            this.migrateOldFactionsDataToNewFormat();
        }
        this.loadFactionsConfigurationLoaders();
    }

    private void loadFactionsConfigurationLoaders() {
        try {
            Stream<Path> pathsStream = Files.list(this.factionsDir);
            pathsStream.forEach(path -> {
                String factionFileName = path.getFileName().toString().toLowerCase();
                HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setDefaultOptions(ConfigurateHelper.getDefaultOptions())).setPath(this.factionsDir.resolve((Path)path))).build();
                this.factionLoaders.put(factionFileName, (ConfigurationLoader<? extends ConfigurationNode>)configurationLoader);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void migrateOldFactionsDataToNewFormat() {
        Path oldFactionsFile = this.configDir.resolve("data").resolve("factions.conf");
        HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setDefaultOptions(ConfigurationOptions.defaults())).setPath(oldFactionsFile)).build();
        try {
            ConfigurationNode configNode = configurationLoader.load();
            List<Faction> factions = ConfigurateHelper.getFactionsFromNode(configNode.getNode(new Object[]{"factions"}));
            ArrayList<Faction> correctedFactions = new ArrayList<Faction>();
            for (Faction faction : factions) {
                HashSet<Claim> updatedClaims = new HashSet<Claim>();
                Object claims = configNode.getNode(new Object[]{"factions", faction.getName(), "claims"}).getValue();
                if (claims != null) {
                    List claimsAsStrings = (List)claims;
                    for (String claimAsString : claimsAsStrings) {
                        String[] worldAndChunk = claimAsString.split("\\|");
                        String world = worldAndChunk[0];
                        String chunk = worldAndChunk[1];
                        UUID worldUUID = UUID.fromString(world);
                        Vector3i chunkPosition = ClaimTypeSerializer.deserializeVector3i(chunk);
                        Claim claim = new Claim(worldUUID, chunkPosition);
                        updatedClaims.add(claim);
                    }
                }
                Faction updatedFaction = faction.toBuilder().setClaims(updatedClaims).build();
                correctedFactions.add(updatedFaction);
            }
            for (Faction faction : correctedFactions) {
                Path factionFilePath = this.configDir.resolve("factions").resolve(faction.getName().toLowerCase() + ".conf");
                if (!Files.notExists(factionFilePath, new LinkOption[0])) continue;
                Files.createFile(factionFilePath, new FileAttribute[0]);
                HoconConfigurationLoader hoconConfigurationLoader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setDefaultOptions(ConfigurateHelper.getDefaultOptions())).setPath(factionFilePath)).build();
                ConfigurationNode node = hoconConfigurationLoader.load();
                ConfigurateHelper.putFactionInNode(node, faction);
                hoconConfigurationLoader.save(node);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void preCreate() {
        if (!this.factionLoaders.containsKey("warzone.conf")) {
            Faction warzone = FactionImpl.builder("WarZone", (Text)Text.of((String)"WZ"), new UUID(0L, 0L)).build();
            this.saveFaction(warzone);
        }
        if (!this.factionLoaders.containsKey("safezone.conf")) {
            Faction safezone = FactionImpl.builder("SafeZone", (Text)Text.of((String)"SZ"), new UUID(0L, 0L)).build();
            this.saveFaction(safezone);
        }
    }

    @Override
    public boolean saveFaction(Faction faction) {
        try {
            ConfigurationNode configurationNode;
            boolean didSucceed;
            FileUtils.createDirectoryIfNotExists(this.factionsDir);
            HoconConfigurationLoader configurationLoader = this.factionLoaders.get(faction.getName().toLowerCase() + ".conf");
            if (configurationLoader == null) {
                Path factionFilePath = this.factionsDir.resolve(faction.getName().toLowerCase() + ".conf");
                Files.createFile(factionFilePath, new FileAttribute[0]);
                configurationLoader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setDefaultOptions(ConfigurateHelper.getDefaultOptions())).setPath(factionFilePath)).build();
                this.factionLoaders.put(factionFilePath.getFileName().toString(), (ConfigurationLoader<? extends ConfigurationNode>)configurationLoader);
            }
            if (didSucceed = ConfigurateHelper.putFactionInNode(configurationNode = configurationLoader.load(), faction)) {
                configurationLoader.save(configurationNode);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean deleteFaction(String factionName) {
        Path filePath = this.factionsDir.resolve(factionName.toLowerCase() + ".conf");
        try {
            Files.deleteIfExists(filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.factionLoaders.remove(factionName.toLowerCase() + ".conf");
        return true;
    }

    @Override
    public void deleteFactions() {
        this.factionLoaders.clear();
        if (Files.notExists(this.factionsDir, new LinkOption[0])) {
            return;
        }
        try {
            Files.list(this.factionsDir).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nullable
    public Faction getFaction(String factionName) {
        HoconConfigurationLoader configurationLoader = this.factionLoaders.get(factionName.toLowerCase() + ".conf");
        if (configurationLoader == null) {
            Path filePath = this.factionsDir.resolve(factionName.toLowerCase() + ".conf");
            if (Files.notExists(filePath, new LinkOption[0])) {
                return null;
            }
            configurationLoader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setDefaultOptions(ConfigurateHelper.getDefaultOptions())).setPath(this.factionsDir.resolve(filePath))).build();
        }
        if (configurationLoader == null) {
            return null;
        }
        try {
            ConfigurationNode configurationNode = configurationLoader.load();
            return ConfigurateHelper.getFactionFromNode(configurationNode);
        }
        catch (IOException | ObjectMappingException e) {
            Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Could not deserialize faction object from file! faction name = " + factionName}));
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Set<Faction> getFactions() {
        try {
            return Files.list(this.factionsDir).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> {
                String factionName = path.getFileName().toString().substring(0, path.getFileName().toString().lastIndexOf("."));
                return this.getFaction(factionName);
            }).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        catch (IOException e) {
            e.printStackTrace();
            return Collections.EMPTY_SET;
        }
    }

    @Override
    public void load() {
        this.loadFactionsConfigurationLoaders();
    }
}

