/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import java.lang.reflect.Field;
import java.util.List;
import mods.railcraft.common.items.RailcraftItems;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import wanion.unidict.integration.AbstractIntegrationThread;

final class VillagerIntegration
extends AbstractIntegrationThread {
    private Field careerList;
    private Field tradeList;
    private Class<?> emeraldForItemstack;
    private Field buyingItem;
    private Class<?> itemstackForEmerald;
    private Field sellingItem;
    private Class<?> genericTrade;
    private Field sale;
    private Field offers;
    private Field offerObj;

    public VillagerIntegration() {
        super("Villagers");
        try {
            this.careerList = VillagerRegistry.VillagerProfession.class.getDeclaredField("careers");
            this.careerList.setAccessible(true);
            this.tradeList = VillagerRegistry.VillagerCareer.class.getDeclaredField("trades");
            this.tradeList.setAccessible(true);
            this.prepareReflectionFromMods();
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            this.logger.error("Couldn't load villager fields/classes!");
            e.printStackTrace();
        }
    }

    public String call() {
        try {
            if (this.careerList != null && this.tradeList != null) {
                this.fixTradeLists();
            }
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
            e.printStackTrace();
        }
        return this.threadName + "Villagers now offer even better deals.";
    }

    private void fixTradeLists() {
        for (VillagerRegistry.VillagerProfession profession : ForgeRegistries.VILLAGER_PROFESSIONS) {
            try {
                List careers = (List)this.careerList.get(profession);
                for (VillagerRegistry.VillagerCareer career : careers) {
                    List trades = (List)this.tradeList.get(career);
                    trades.forEach(tradesForLevel -> tradesForLevel.forEach(this::fixTradeList));
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void fixTradeList(EntityVillager.ITradeList list) {
        if (list instanceof EntityVillager.ItemAndEmeraldToItem) {
            EntityVillager.ItemAndEmeraldToItem itemAndEmeraldToItem = (EntityVillager.ItemAndEmeraldToItem)list;
            itemAndEmeraldToItem.field_179411_a = this.resourceHandler.getMainItemStack(itemAndEmeraldToItem.field_179411_a);
            itemAndEmeraldToItem.field_179410_c = this.resourceHandler.getMainItemStack(itemAndEmeraldToItem.field_179410_c);
        } else if (list instanceof EntityVillager.ListItemForEmeralds) {
            EntityVillager.ListItemForEmeralds listItemForEmeralds = (EntityVillager.ListItemForEmeralds)list;
            listItemForEmeralds.field_179403_a = this.resourceHandler.getMainItemStack(listItemForEmeralds.field_179403_a);
        } else if (this.emeraldForItemstack != null && this.emeraldForItemstack.isInstance(list)) {
            try {
                this.buyingItem.set(list, this.resourceHandler.getMainItemStack((ItemStack)this.buyingItem.get(list)));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (this.itemstackForEmerald != null && this.itemstackForEmerald.isInstance(list)) {
            try {
                this.sellingItem.set(list, this.resourceHandler.getMainItemStack((ItemStack)this.sellingItem.get(list)));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (this.genericTrade != null && this.genericTrade.isInstance(list)) {
            try {
                Object[] sellOffers;
                Object saleOffer = this.sale.get(list);
                this.offerObj.set(saleOffer, this.resourceHandler.getMainItemStack(this.getRailCraftOfferItem(this.offerObj.get(saleOffer))));
                for (Object sellOffer : sellOffers = (Object[])this.offers.get(list)) {
                    this.offerObj.set(sellOffer, this.resourceHandler.getMainItemStack(this.getRailCraftOfferItem(this.offerObj.get(sellOffer))));
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void prepareReflectionFromMods() throws NoSuchFieldException, ClassNotFoundException {
        if (Loader.isModLoaded((String)"immersiveengineering")) {
            this.emeraldForItemstack = Class.forName("blusunrize.immersiveengineering.common.util.IEVillagerHandler$EmeraldForItemstack");
            this.buyingItem = this.emeraldForItemstack.getField("buyingItem");
            this.buyingItem.setAccessible(true);
            this.itemstackForEmerald = Class.forName("blusunrize.immersiveengineering.common.util.IEVillagerHandler$ItemstackForEmerald");
            this.sellingItem = this.itemstackForEmerald.getField("sellingItem");
            this.sellingItem.setAccessible(true);
        }
        if (Loader.isModLoaded((String)"railcraft")) {
            this.genericTrade = Class.forName("mods.railcraft.common.worldgen.VillagerTrades$GenericTrade");
            this.sale = this.genericTrade.getDeclaredField("sale");
            this.sale.setAccessible(true);
            this.offers = this.genericTrade.getDeclaredField("offers");
            this.offers.setAccessible(true);
            this.offerObj = Class.forName("mods.railcraft.common.worldgen.VillagerTrades$Offer").getDeclaredField("obj");
            this.offerObj.setAccessible(true);
        }
    }

    private ItemStack getRailCraftOfferItem(Object obj) {
        if (obj instanceof RailcraftItems) {
            return ((RailcraftItems)obj).getStack();
        }
        if (obj instanceof ItemStack) {
            return (ItemStack)obj;
        }
        if (obj instanceof Item) {
            return new ItemStack((Item)obj);
        }
        if (obj instanceof Block) {
            return new ItemStack((Block)obj);
        }
        return ItemStack.field_190927_a;
    }
}

