/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy.dimension.world.gen.dungeons.standart;

import asmodeuscore.core.astronomy.dimension.world.gen.dungeons.standart.DungeonConfiguration;
import asmodeuscore.core.astronomy.dimension.world.gen.dungeons.standart.DungeonStart;
import asmodeuscore.core.astronomy.dimension.world.gen.dungeons.standart.Piece;
import asmodeuscore.core.astronomy.dimension.world.gen.dungeons.standart.RoomBoss;
import asmodeuscore.core.astronomy.dimension.world.gen.dungeons.standart.SizedPiece;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockTier1TreasureChest;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTreasureChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public class RoomTreasure
extends SizedPiece {
    public RoomTreasure() {
    }

    public RoomTreasure(DungeonConfiguration configuration, Random rand, int blockPosX, int blockPosZ, EnumFacing entranceDir) {
        this(configuration, rand, blockPosX, blockPosZ, rand.nextInt(4) + 6, configuration.getRoomHeight(), rand.nextInt(4) + 6, entranceDir);
    }

    public RoomTreasure(DungeonConfiguration configuration, Random rand, int blockPosX, int blockPosZ, int sizeX, int sizeY, int sizeZ, EnumFacing entranceDir) {
        super(configuration, sizeX, sizeY, sizeZ, entranceDir.func_176734_d());
        this.func_186164_a(EnumFacing.SOUTH);
        int yPos = configuration.getYPosition();
        this.field_74887_e = new StructureBoundingBox(blockPosX, yPos, blockPosZ, blockPosX + this.sizeX, yPos + this.sizeY, blockPosZ + this.sizeZ);
    }

    public boolean func_74875_a(World worldIn, Random random, StructureBoundingBox chunkBox) {
        for (int i = 0; i <= this.sizeX; ++i) {
            for (int j = 0; j <= this.sizeY; ++j) {
                for (int k = 0; k <= this.sizeZ; ++k) {
                    if (i == 0 || i == this.sizeX || j == 0 || j == this.sizeY || k == 0 || k == this.sizeZ) {
                        int end;
                        int start;
                        boolean placeBlock = true;
                        if (this.getDirection().func_176740_k() == EnumFacing.Axis.Z) {
                            start = (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 - 1;
                            end = (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 + 1;
                            if (i > start && i <= end && j < 3 && j > 0) {
                                if (this.getDirection() == EnumFacing.SOUTH && k == 0) {
                                    placeBlock = false;
                                } else if (this.getDirection() == EnumFacing.NORTH && k == this.sizeZ) {
                                    placeBlock = false;
                                }
                            }
                        } else {
                            start = (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 - 1;
                            end = (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 + 1;
                            if (k > start && k <= end && j < 3 && j > 0) {
                                if (this.getDirection() == EnumFacing.EAST && i == 0) {
                                    placeBlock = false;
                                } else if (this.getDirection() == EnumFacing.WEST && i == this.sizeX) {
                                    placeBlock = false;
                                }
                            }
                        }
                        if (placeBlock) {
                            this.func_175811_a(worldIn, this.configuration.getBrickBlock(), i, j, k, chunkBox);
                            continue;
                        }
                        this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, chunkBox);
                        continue;
                    }
                    if (i == 1 && k == 1 || i == 1 && k == this.sizeZ - 1 || i == this.sizeX - 1 && k == 1 || i == this.sizeX - 1 && k == this.sizeZ - 1) {
                        this.func_175811_a(worldIn, Blocks.field_150426_aN.func_176223_P(), i, j, k, chunkBox);
                        continue;
                    }
                    if (i == this.sizeX / 2 && j == 1 && k == this.sizeZ / 2) {
                        BlockPos blockpos = new BlockPos(this.func_74865_a(i, k), this.func_74862_a(j), this.func_74873_b(i, k));
                        if (!chunkBox.func_175898_b((Vec3i)blockpos)) continue;
                        worldIn.func_180501_a(blockpos, GCBlocks.treasureChestTier1.func_176223_P().func_177226_a((IProperty)BlockTier1TreasureChest.FACING, (Comparable)this.getDirection().func_176734_d()), 2);
                        TileEntityTreasureChest treasureChest = (TileEntityTreasureChest)worldIn.func_175625_s(blockpos);
                        if (treasureChest == null) continue;
                        ResourceLocation chesttype = micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomTreasure.TABLE_TIER_1_DUNGEON;
                        if (worldIn.field_73011_w instanceof IGalacticraftWorldProvider) {
                            chesttype = ((IGalacticraftWorldProvider)worldIn.field_73011_w).getDungeonChestType();
                        }
                        treasureChest.setLootTable(chesttype, random.nextLong());
                        continue;
                    }
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, chunkBox);
                }
            }
        }
        return true;
    }

    @Override
    public Piece getNextPiece(DungeonStart startPiece, Random rand) {
        StructureComponent component;
        if (startPiece.attachedComponents.size() > 2 && (component = startPiece.attachedComponents.get(startPiece.attachedComponents.size() - 3)) instanceof RoomBoss) {
            BlockPos blockpos = new BlockPos(this.func_74865_a(this.sizeX / 2, this.sizeZ / 2), this.func_74862_a(1), this.func_74873_b(this.sizeX / 2, this.sizeZ / 2));
            ((RoomBoss)component).setChestPos(new BlockPos((Vec3i)blockpos));
        }
        return null;
    }
}

