/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.experience.listener;

import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.ExperienceOrb;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.RespawnPlayerEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.Tristate;

public class ExperienceListener
implements ListenerBase {
    private final IPermissionService permissionService;
    private final Map<UUID, Integer> deadExpPlayers = new HashMap<UUID, Integer>();
    private final PluginContainer pluginContainer;

    @Inject
    public ExperienceListener(INucleusServiceCollection serviceCollection) {
        this.permissionService = serviceCollection.permissionService();
        this.pluginContainer = serviceCollection.pluginContainer();
    }

    @Listener(order=Order.POST)
    public void onPlayerDeathMonitor(DestructEntityEvent.Death deathEvent, @Getter(value="getTargetEntity") Player player) {
        Tristate tristate = this.permissionService.hasPermissionTristate((Subject)player, "nucleus.exp.keepondeath");
        if (tristate == Tristate.TRUE) {
            int exp = player.get(Keys.TOTAL_EXPERIENCE).orElse(0);
            this.deadExpPlayers.put(player.getUniqueId(), exp);
        } else if (tristate == Tristate.FALSE) {
            this.deadExpPlayers.put(player.getUniqueId(), 0);
        }
    }

    @Listener
    public void preventExperienceDroppingOrb(SpawnEntityEvent event, @Root Player player) {
        if (this.deadExpPlayers.getOrDefault(player.getUniqueId(), 0) > 0) {
            event.filterEntities(entity -> !(entity instanceof ExperienceOrb));
        }
    }

    @Listener
    public void onPlayerRespawn(RespawnPlayerEvent event, @Getter(value="getTargetEntity") Player player) {
        this.applyExperience(player);
    }

    @Listener
    public void onPlayerJoin(ClientConnectionEvent.Join event, @Getter(value="getTargetEntity") Player player) {
        this.applyExperience(player);
    }

    private void applyExperience(Player player) {
        if (this.deadExpPlayers.containsKey(player.getUniqueId())) {
            int exp = this.deadExpPlayers.get(player.getUniqueId());
            Task.builder().delayTicks(1L).execute(() -> player.offer(Keys.TOTAL_EXPERIENCE, (Object)exp)).submit((Object)this.pluginContainer);
            this.deadExpPlayers.remove(player.getUniqueId());
        }
    }
}

