/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.fun.commands;

import com.flowpowered.math.imaginary.Quaterniond;
import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.OcelotType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.explosion.Explosion;

@NonnullByDefault
@Command(aliases={"kittycannon", "kc"}, basePermission={"nucleus.kittycannon.base"}, commandDescriptionKey="kittycannon", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.kittycannon.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.kittycannon.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.kittycannon.exempt.cost")}, associatedPermissions={"nucleus.kittycannon.others"})
public class KittyCannonCommand
implements ICommandExecutor<CommandSource> {
    private final Random random = new Random();
    private final List<OcelotType> ocelotTypes = Lists.newArrayList((Iterable)Sponge.getRegistry().getAllOf(OcelotType.class));

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().permissionFlag("nucleus.kittycannon.damage", new String[]{"d", "-damageentities"}).permissionFlag("nucleus.kittycannon.break", new String[]{"b", "-breakblocks"}).permissionFlag("nucleus.kittycannon.fire", new String[]{"f", "-fire"}).buildWith(GenericArguments.optional((CommandElement)serviceCollection.commandElementSupplier().createPermissionParameter(NucleusParameters.MANY_PLAYER.get(serviceCollection), "nucleus.kittycannon.others", false)))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        ImmutableList playerList = context.getAll("player", Player.class);
        if (playerList.isEmpty()) {
            playerList = ImmutableList.of((Object)context.getIfPlayer());
        }
        for (Player x : playerList) {
            this.getACat(context, x, context.hasAny("d"), context.hasAny("b"), context.hasAny("f"));
        }
        return context.successResult();
    }

    private void getACat(ICommandContext<? extends CommandSource> context, Player spawnAt, boolean damageEntities, boolean breakBlocks, boolean causeFire) throws CommandException {
        Vector3d headRotation = spawnAt.getHeadRotation();
        Quaterniond rot = Quaterniond.fromAxesAnglesDeg((double)headRotation.getX(), (double)(-headRotation.getY()), (double)headRotation.getZ());
        Vector3d velocity = spawnAt.getVelocity().add(rot.rotate(Vector3d.UNIT_Z).mul(5.0 * this.random.nextDouble() + 1.0));
        World world = spawnAt.getWorld();
        Entity cat = world.createEntity(EntityTypes.OCELOT, spawnAt.getLocation().getPosition().add(0.0f, 1.0f, 0.0f).add(spawnAt.getTransform().getRotationAsQuaternion().getDirection()));
        cat.offer(Keys.OCELOT_TYPE, (Object)this.ocelotTypes.get(this.random.nextInt(this.ocelotTypes.size())));
        Sponge.getScheduler().createTaskBuilder().intervalTicks(5L).delayTicks(5L).execute((Consumer)new CatTimer(world.getUniqueId(), cat.getUniqueId(), spawnAt, this.random.nextInt(60) + 20, damageEntities, breakBlocks, causeFire)).submit((Object)context.getServiceCollection().pluginContainer());
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause((Object)context.getCommandSource());
            world.spawnEntity(cat);
        }
        cat.offer(Keys.VELOCITY, (Object)velocity);
    }

    private static class CatTimer
    implements Consumer<Task> {
        private final UUID entity;
        private final UUID world;
        private final Player player;
        private final boolean damageEntities;
        private final boolean causeFire;
        private final boolean breakBlocks;
        private int ticksToDestruction;

        private CatTimer(UUID world, UUID entity, Player player, int ticksToDestruction, boolean damageEntities, boolean breakBlocks, boolean causeFire) {
            this.entity = entity;
            this.ticksToDestruction = ticksToDestruction;
            this.world = world;
            this.player = player;
            this.damageEntities = damageEntities;
            this.breakBlocks = breakBlocks;
            this.causeFire = causeFire;
        }

        @Override
        public void accept(Task task) {
            Optional oWorld = Sponge.getServer().getWorld(this.world);
            if (!oWorld.isPresent()) {
                task.cancel();
                return;
            }
            Optional oe = ((World)oWorld.get()).getEntity(this.entity);
            if (!oe.isPresent()) {
                task.cancel();
                return;
            }
            Entity e = (Entity)oe.get();
            if (e.isRemoved()) {
                task.cancel();
                return;
            }
            this.ticksToDestruction -= 5;
            if (this.ticksToDestruction <= 0 || e.isOnGround()) {
                Explosion explosion = Explosion.builder().location(e.getLocation()).canCauseFire(this.causeFire).shouldDamageEntities(this.damageEntities).shouldPlaySmoke(true).shouldBreakBlocks(this.breakBlocks).radius(2.0f).build();
                e.remove();
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                    frame.pushCause((Object)this.player);
                    ((World)oWorld.get()).triggerExplosion(explosion);
                }
                task.cancel();
            }
        }
    }
}

