/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.info.commands;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.io.TextFileController;
import io.github.nucleuspowered.nucleus.modules.info.config.InfoConfig;
import io.github.nucleuspowered.nucleus.modules.info.parameter.InfoArgument;
import io.github.nucleuspowered.nucleus.modules.info.services.InfoHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"info", "einfo"}, async=true, basePermission={"nucleus.info.base"}, commandDescriptionKey="info", associatedPermissions={"nucleus.info.list"})
@EssentialsEquivalent(value={"info", "ifo", "news", "about", "inform"})
public class InfoCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private final InfoHandler infoService;
    private InfoConfig infoConfig = new InfoConfig();
    private final String key = "section";

    @Inject
    public InfoCommand(INucleusServiceCollection serviceCollection) {
        this.infoService = serviceCollection.getServiceUnchecked(InfoHandler.class);
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.infoConfig = serviceCollection.moduleDataProvider().getModuleConfig(InfoConfig.class);
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().valueFlag((CommandElement)serviceCollection.commandElementSupplier().createPermissionParameter(GenericArguments.markTrue((Text)Text.of((String)"list")), "nucleus.info.list", false), new String[]{"l", "-list"}).buildWith(GenericArguments.optional((CommandElement)new InfoArgument((Text)Text.of((String)this.key), this.infoService, serviceCollection)))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        String def;
        Optional<TextFileController> list;
        Optional<InfoArgument.Result> oir = context.getOne(this.key, InfoArgument.Result.class);
        if (this.infoConfig.isUseDefaultFile() && !oir.isPresent() && !context.hasAny("l") && (list = this.infoService.getSection(def = this.infoConfig.getDefaultInfoSection())).isPresent()) {
            oir = Optional.of(new InfoArgument.Result(this.infoService.getInfoSections().stream().filter(def::equalsIgnoreCase).findFirst().get(), list.get()));
        }
        if (oir.isPresent()) {
            TextFileController controller = oir.get().text;
            Text def2 = TextSerializers.FORMATTING_CODE.deserialize(oir.get().name);
            Text title = context.getMessage("command.info.title.section", controller.getTitle(context.getCommandSource()).orElseGet(() -> Text.of((Object[])new Object[]{def2})));
            controller.sendToPlayer(context.getCommandSource(), title);
            return context.successResult();
        }
        Set<String> sections = this.infoService.getInfoSections();
        if (sections.isEmpty()) {
            return context.errorResult("command.info.none", new Object[0]);
        }
        ArrayList s = Lists.newArrayList();
        sections.forEach(x -> {
            Text.Builder tb = Text.builder().append(new Text[]{Text.builder((String)x).color(TextColors.GREEN).style(new TextStyle[]{TextStyles.ITALIC}).onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.info.hover", x))).onClick((ClickAction)TextActions.runCommand((String)("/info " + x))).build()});
            this.infoService.getSection((String)x).get().getTitle((CommandSource)context.getCommandSourceUnchecked()).ifPresent(sub -> tb.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, " - "})}).append(new Text[]{sub}));
            s.add(tb.build());
        });
        Util.getPaginationBuilder(context.getCommandSource()).contents(new Text[0]).header(context.getMessage("command.info.header.default", new Object[0])).title(context.getMessage("command.info.title.default", new Object[0])).contents((Iterable)s.stream().sorted(Comparator.comparing(Text::toPlain)).collect(Collectors.toList())).padding(Text.of((Object[])new Object[]{TextColors.GOLD, "-"})).sendTo((MessageReceiver)context.getCommandSource());
        return context.successResult();
    }
}

