/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands.lore;

import io.github.nucleuspowered.nucleus.modules.item.commands.lore.LoreCommand;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.data.manipulator.mutable.item.LoreData;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"clear"}, basePermission={"nucleus.lore.set.base"}, commandDescriptionKey="lore.clear", parentCommand=LoreCommand.class, modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.lore.set.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.lore.set.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.lore.set.exempt.cost")})
public class LoreClearCommand
implements ICommandExecutor<Player> {
    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Player src = context.getIfPlayer();
        if (!src.getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
            return context.errorResult("command.lore.clear.noitem", new Object[0]);
        }
        ItemStack stack = (ItemStack)src.getItemInHand(HandTypes.MAIN_HAND).get();
        LoreData loreData = (LoreData)stack.getOrCreate(LoreData.class).get();
        if (loreData.lore().isEmpty()) {
            return context.errorResult("command.lore.clear.none", new Object[0]);
        }
        if (stack.remove(LoreData.class).isSuccessful()) {
            src.setItemInHand(HandTypes.MAIN_HAND, stack);
            context.errorResult("command.lore.clear.success", new Object[0]);
            return context.successResult();
        }
        return context.errorResult("command.lore.clear.fail", new Object[0]);
    }
}

