/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jail.commands;

import io.github.nucleuspowered.nucleus.configurate.config.CommonPermissionLevelConfig;
import io.github.nucleuspowered.nucleus.modules.jail.config.JailConfig;
import io.github.nucleuspowered.nucleus.modules.jail.services.JailHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"unjail"}, basePermission={"nucleus.jail.unjail"}, commandDescriptionKey="unjail", associatedPermissionLevelKeys={"nucleus.jail.level"})
@EssentialsEquivalent(value={"unjail"}, isExact=false, notes="Not a toggle.")
public class UnjailCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private final JailHandler handler;
    private CommonPermissionLevelConfig levelConfig = new CommonPermissionLevelConfig();

    @Inject
    public UnjailCommand(INucleusServiceCollection serviceCollection) {
        this.handler = serviceCollection.getServiceUnchecked(JailHandler.class);
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.ONE_USER.get(serviceCollection)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        User user = context.requireOne("user", User.class);
        if (this.levelConfig.isUseLevels() && !context.isPermissionLevelOkay((Subject)user, "nucleus.jail.level", "nucleus.jail.base", this.levelConfig.isCanAffectSameLevel())) {
            return context.errorResult("command.modifiers.level.insufficient", user.getName());
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause((Object)context.getCommandSource());
            if (this.handler.unjailPlayer(user)) {
                context.sendMessage("command.jail.unjail.success", user.getName());
                ICommandResult iCommandResult = context.successResult();
                return iCommandResult;
            }
            ICommandResult iCommandResult = context.errorResult("command.jail.unjail.fail", user.getName());
            return iCommandResult;
        }
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.levelConfig = serviceCollection.moduleDataProvider().getModuleConfig(JailConfig.class).getCommonPermissionLevelConfig();
    }
}

